/*
 * Copyright 2012 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.api.speech.osgi;

import java.util.Map;
import java.util.Properties;
import org.robokind.api.common.osgi.AbstractLifecycleProvider;
import org.robokind.api.common.osgi.DescriptorListBuilder;
import org.robokind.api.common.triggering.Trigger;
import org.robokind.api.common.triggering.TriggerHandler;
import org.robokind.api.speech.SpeechService;
import org.robokind.api.speech.utils.SpeechTriggerHandler;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class SpeechTriggerHandlerLifecycleProvider extends 
        AbstractLifecycleProvider<TriggerHandler, SpeechTriggerHandler> {    
    private final static String theDepSpeechServiceId = "speechService";
    
    public SpeechTriggerHandlerLifecycleProvider(
            String speechServiceId){
        super(new DescriptorListBuilder()
                .addId(theDepSpeechServiceId, SpeechService.class, 
                        SpeechService.PROP_ID, speechServiceId)
                .getDescriptors());
        myRegistrationProperties = new Properties();
        myRegistrationProperties.put(
                Trigger.PROP_TRIGGER_TYPE, 
                SpeechTriggerHandler.SPEECH_TRIGGER_TYPE);
    }

    @Override
    protected SpeechTriggerHandler create(Map<String, Object> services) {
        SpeechService speechService = 
                (SpeechService)services.get(theDepSpeechServiceId);
        return new SpeechTriggerHandler(speechService);
    }

    @Override
    protected void handleChange(String serviceId, Object service) {
        if(theDepSpeechServiceId.equals(serviceId)){
            myService.setSpeechService((SpeechService)service);
        }
    }

    @Override
    public Class<TriggerHandler> getServiceClass() {
        return TriggerHandler.class;
    }
}
