/*
 * Copyright 2012 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.api.speech.utils;

import java.util.ArrayList;
import java.util.List;
import org.robokind.api.common.utils.Listener;
import org.robokind.api.speech.SpeechEvent;
import org.robokind.api.speech.SpeechEventList;

/**
 *
 * @author robokind
 */
public class SpeechEventNotifier implements Listener<SpeechEventList>{
    private List<Listener<SpeechEvent>> mySpeechEventListeners;
    
    public SpeechEventNotifier(){
        mySpeechEventListeners = new ArrayList<Listener<SpeechEvent>>();
    }
    
    @Override
    public void handleEvent(SpeechEventList t) {
        if(t == null || t.getSpeechEvents() == null){
            throw new NullPointerException();
        }
        for(SpeechEvent ev : t.getSpeechEvents()){
            if(ev == null){
                throw new NullPointerException();
            }
            fireSpeechEvent(ev);
        }
    }
    
    public void fireSpeechEvent(SpeechEvent ev){
        for(Listener<SpeechEvent> listener : mySpeechEventListeners){
            listener.handleEvent(ev);
        }
    }
    
    public void addSpeechEventListener(Listener<SpeechEvent> listener){
        if(listener == null){
            throw new NullPointerException();
        }
        if(!mySpeechEventListeners.contains(listener)){
            mySpeechEventListeners.add(listener);
        }
    }
    
    public void removeSpeechEventListener(Listener<SpeechEvent> listener){
        if(listener == null){
            throw new NullPointerException();
        }
        if(mySpeechEventListeners.contains(listener)){
            mySpeechEventListeners.remove(listener);
        }
    }
    
}
