/*
 * Copyright 2012 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.api.speech.viseme;

import java.util.EnumMap;
import java.util.Map;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.speech.viseme.config.VisemeBindingConfig;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class VisemeBinding{
    private int myBindingKey;
    private Map<Viseme,NormalizedDouble> myVisemeValueMap;
    
    public VisemeBinding(int key){
        myBindingKey = key;
        myVisemeValueMap = new EnumMap<Viseme, NormalizedDouble>(Viseme.class);
    }
    
    public VisemeBinding(VisemeBindingConfig config){
        this(config.getBindingId());
        myVisemeValueMap.putAll(config.getVisemePositions());
    }
    
    public int getBindingKey(){
        return myBindingKey;
    }
    
    public NormalizedDouble getValue(Viseme viseme){
        if(viseme == null){
            throw new NullPointerException();
        }
        return myVisemeValueMap.get(viseme);
    }
    
    public void setVisemeValue(Viseme viseme, NormalizedDouble value){
        if(viseme == null){
            throw new NullPointerException();
        }
        myVisemeValueMap.put(viseme, value);
    }
}
