/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.api.speech.viseme;

import java.util.ArrayList;
import java.util.List;
import org.robokind.api.common.utils.Listener;
import org.robokind.api.speech.SpeechEvent;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class VisemeEventNotifier implements Listener<SpeechEvent>{
    private List<Listener<VisemeEvent>> myListeners;
    
    public VisemeEventNotifier(){
        myListeners = new ArrayList<Listener<VisemeEvent>>();
    }
    
    public void addListener(Listener<VisemeEvent> listener){
        if(!myListeners.contains(listener)){
            myListeners.add(listener);
        }
    }
        
    @Override
    public void handleEvent(SpeechEvent event) {
        if(event == null || event.getSpeechEventType() == null 
                || myListeners.isEmpty()){
            return;
        }
        if(event.getSpeechEventType().equals("VISEME")){
            handleVisemeEvent(new DefaultVisemeEvent(event));
        }
    }

    public void handleVisemeEvent(VisemeEvent event) {
        for(Listener<VisemeEvent> l : myListeners){
            l.handleEvent(event);
        }
    }
    
}
