/*
 * Copyright 2012 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.api.speech.viseme.config;

import java.util.List;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.services.ServiceFactory;
import org.robokind.api.speech.viseme.VisemeBinding;
import org.robokind.api.speech.viseme.VisemeBindingManager;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class VisemeBindingManagerServiceFactory implements ServiceFactory<VisemeBindingManager, VisemeBindingManagerConfig> {
        
    public VisemeBindingManager buildVisemeBindingManager(
            VisemeBindingManagerConfig config){
        if(config == null){
            throw new NullPointerException();
        }
        VisemeBindingManager manager = new VisemeBindingManager();
        List<VisemeBindingConfig> configs = config.getVisemeBindingConfigs();
        if(configs == null){
            throw new NullPointerException();
        }
        for(VisemeBindingConfig bindingConfig : configs){
            manager.addBinding(buildVisemeBinding(bindingConfig));
        }
        return manager;
    }
    
    protected VisemeBinding buildVisemeBinding(VisemeBindingConfig config){
        if(config == null){
            throw new NullPointerException();
        }
        return new VisemeBinding(config.getBindingId());
    }

    @Override
    public VersionProperty getServiceVersion() {
        return VisemeBindingManager.VERSION;
    }

    @Override
    public VisemeBindingManager build(VisemeBindingManagerConfig config) {
        if(config == null){
            throw new NullPointerException();
        }
        VisemeBindingManager manager = new VisemeBindingManager();
        List<VisemeBindingConfig> configs = config.getVisemeBindingConfigs();
        if(configs == null){
            throw new NullPointerException();
        }
        for(VisemeBindingConfig bindingConfig : configs){
            manager.addBinding(buildVisemeBinding(bindingConfig));
        }
        return manager;
    }

    @Override
    public Class<VisemeBindingManager> getServiceClass() {
        return VisemeBindingManager.class;
    }

    @Override
    public Class<VisemeBindingManagerConfig> getServiceConfigurationClass() {
        return VisemeBindingManagerConfig.class;
    }
}
