/*
 * Copyright 2012 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.api.speech.viseme.osgi;

import java.util.Map;
import java.util.Properties;
import org.robokind.api.common.osgi.AbstractLifecycleProvider;
import org.robokind.api.common.osgi.DescriptorListBuilder;
import org.robokind.api.speech.SpeechService;
import org.robokind.api.speech.viseme.VisemeEventNotifier;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class VisemeEventNotifierLifecycleProvider extends AbstractLifecycleProvider<VisemeEventNotifier, VisemeEventNotifier> {
    private final static String theDepSpeechService = "speechService";
    
    public VisemeEventNotifierLifecycleProvider(String speechServiceId){
        super(new DescriptorListBuilder()
                .addId(theDepSpeechService, SpeechService.class, 
                        SpeechService.PROP_ID, speechServiceId)
                .getDescriptors());
        
        myRegistrationProperties = new Properties();
        myRegistrationProperties.put(
                SpeechService.PROP_ID, speechServiceId);
    }

    @Override
    protected VisemeEventNotifier create(Map<String, Object> services) {
        SpeechService speech = (SpeechService)services.get(theDepSpeechService);
        VisemeEventNotifier ven = new VisemeEventNotifier();
        speech.addSpeechEventListener(ven);
        return ven;
    }
    
    @Override
    protected void handleChange(String serviceId, Object service) {
    }

    @Override
    public Class<VisemeEventNotifier> getServiceClass() {
        return VisemeEventNotifier.class;
    }
    
}
