/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.speech.utils;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.robokind.api.common.triggering.Trigger;
import org.robokind.api.common.triggering.TriggerHandler;
import org.robokind.api.speech.SpeechService;

public class SpeechTriggerHandler
implements TriggerHandler {
    private static final Logger theLogger = Logger.getLogger(SpeechTriggerHandler.class.getName());
    public static final String SPEECH_TRIGGER_TYPE = "Speech";
    public static final String PROP_SPEECH_TEXT = "speechText";
    private SpeechService mySpeechService;

    public SpeechTriggerHandler(SpeechService speechService) {
        this.mySpeechService = speechService;
    }

    public void setSpeechService(SpeechService speechService) {
        this.mySpeechService = speechService;
    }

    public void handleTrigger(Trigger trigger) {
        if (this.mySpeechService == null) {
            theLogger.warning("SpeechService is null.  Ignoring Trigger.");
            return;
        }
        if (trigger == null) {
            throw new NullPointerException();
        }
        if (!this.getTriggerType().equals(trigger.getTriggerType())) {
            theLogger.log(Level.WARNING, "Invalid TriggerType.  Expected: {0}, Found: {1}", new Object[]{this.getTriggerType(), trigger.getTriggerType()});
            return;
        }
        Properties props = trigger.getTriggerProperties();
        if (props == null) {
            throw new NullPointerException();
        }
        String text = props.getProperty(PROP_SPEECH_TEXT);
        if (text == null) {
            throw new NullPointerException();
        }
        this.mySpeechService.speak(text);
    }

    public String getTriggerType() {
        return SPEECH_TRIGGER_TYPE;
    }
}

