/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.speech.viseme;

import java.util.ArrayList;
import java.util.List;
import org.robokind.api.common.utils.Listener;
import org.robokind.api.speech.SpeechEvent;
import org.robokind.api.speech.viseme.DefaultVisemeEvent;
import org.robokind.api.speech.viseme.VisemeEvent;

public class VisemeEventNotifier
implements Listener<SpeechEvent> {
    private List<Listener<VisemeEvent>> myListeners = new ArrayList<Listener<VisemeEvent>>();

    public void addListener(Listener<VisemeEvent> listener) {
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    public void handleEvent(SpeechEvent event) {
        if (event == null || event.getSpeechEventType() == null || this.myListeners.isEmpty()) {
            return;
        }
        if (event.getSpeechEventType().equals("VISEME")) {
            this.handleVisemeEvent(new DefaultVisemeEvent(event));
        }
    }

    public void handleVisemeEvent(VisemeEvent event) {
        for (Listener<VisemeEvent> l : this.myListeners) {
            l.handleEvent((Object)event);
        }
    }
}

