/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.speech.viseme.config;

import java.util.List;
import java.util.Map;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.services.ServiceFactory;
import org.robokind.api.speech.viseme.Viseme;
import org.robokind.api.speech.viseme.VisemeBinding;
import org.robokind.api.speech.viseme.VisemeBindingManager;
import org.robokind.api.speech.viseme.config.VisemeBindingConfig;
import org.robokind.api.speech.viseme.config.VisemeBindingManagerConfig;

public class VisemeBindingManagerServiceFactory
implements ServiceFactory<VisemeBindingManager, VisemeBindingManagerConfig> {
    public VisemeBindingManager buildVisemeBindingManager(VisemeBindingManagerConfig config) {
        if (config == null) {
            throw new NullPointerException();
        }
        VisemeBindingManager manager = new VisemeBindingManager();
        List<VisemeBindingConfig> configs = config.getVisemeBindingConfigs();
        if (configs == null) {
            throw new NullPointerException();
        }
        for (VisemeBindingConfig bindingConfig : configs) {
            manager.addBinding(this.buildVisemeBinding(bindingConfig));
        }
        return manager;
    }

    protected VisemeBinding buildVisemeBinding(VisemeBindingConfig config) {
        if (config == null) {
            throw new NullPointerException();
        }
        VisemeBinding vb = new VisemeBinding(config.getBindingKey());
        Map<Viseme, NormalizedDouble> visMap = config.getVisemeValues();
        for (Map.Entry<Viseme, NormalizedDouble> e : visMap.entrySet()) {
            vb.setVisemeValue(e.getKey(), e.getValue());
        }
        return vb;
    }

    public VersionProperty getServiceVersion() {
        return VisemeBindingManager.VERSION;
    }

    public VisemeBindingManager build(VisemeBindingManagerConfig config) {
        if (config == null) {
            throw new NullPointerException();
        }
        VisemeBindingManager manager = new VisemeBindingManager();
        List<VisemeBindingConfig> configs = config.getVisemeBindingConfigs();
        if (configs == null) {
            throw new NullPointerException();
        }
        for (VisemeBindingConfig bindingConfig : configs) {
            manager.addBinding(this.buildVisemeBinding(bindingConfig));
        }
        return manager;
    }

    public Class<VisemeBindingManager> getServiceClass() {
        return VisemeBindingManager.class;
    }

    public Class<VisemeBindingManagerConfig> getServiceConfigurationClass() {
        return VisemeBindingManagerConfig.class;
    }
}

