/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.speech.viseme;

import java.util.ArrayList;
import java.util.List;
import org.robokind.api.common.utils.Listener;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.speech.SpeechEvent;
import org.robokind.api.speech.viseme.DefaultVisemeEvent;
import org.robokind.api.speech.viseme.VisemeEvent;

public class VisemeEventNotifier
implements Listener<SpeechEvent> {
    private List<Listener<VisemeEvent>> myListeners = new ArrayList<Listener<VisemeEvent>>();
    private long myRemoteStartTime;
    private long myLocalStartTime;
    private long myTimeOffset;

    public void addListener(Listener<VisemeEvent> listener) {
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    public void removeListener(Listener<VisemeEvent> listener) {
        if (this.myListeners.contains(listener)) {
            this.myListeners.remove(listener);
        }
    }

    public void handleEvent(SpeechEvent event) {
        if (event == null || event.getSpeechEventType() == null || this.myListeners.isEmpty()) {
            return;
        }
        if ("SPEECH_START".equals(event.getSpeechEventType())) {
            this.myLocalStartTime = TimeUtils.now();
            this.myRemoteStartTime = event.getTimestampMillisecUTC();
            this.myTimeOffset = this.myLocalStartTime - this.myRemoteStartTime;
        } else if ("VISEME".equals(event.getSpeechEventType())) {
            this.handleVisemeEvent(new DefaultVisemeEvent(event, this.myTimeOffset));
        }
    }

    public void handleVisemeEvent(VisemeEvent event) {
        for (Listener<VisemeEvent> l : this.myListeners) {
            l.handleEvent((Object)event);
        }
    }
}

