/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.speech.viseme;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.robokind.api.common.utils.Listener;
import org.robokind.api.speech.viseme.VisemeEvent;

public class VisemeEventQueue {
    private SortedSet<VisemeEvent> myEvents = new ConcurrentSkipListSet<VisemeEvent>(new VisemeEventComparator());
    private VisemeListener myListener = new VisemeListener();

    public Listener<VisemeEvent> getListener() {
        return this.myListener;
    }

    public synchronized void clear() {
        this.myEvents.clear();
    }

    public VisemeEvent getEvent(long timeUTC) {
        if (this.myEvents.isEmpty()) {
            return null;
        }
        VisemeEvent ev = this.myEvents.first();
        if (timeUTC <= ev.getTimestampMillisecUTC() + (long)ev.getDuration()) {
            return ev;
        }
        this.myEvents.remove(ev);
        if (this.myEvents.isEmpty()) {
            return null;
        }
        return this.myEvents.first();
    }

    class VisemeListener
    implements Listener<VisemeEvent> {
        VisemeListener() {
        }

        public void handleEvent(VisemeEvent event) {
            VisemeEventQueue.this.myEvents.add(event);
        }
    }

    class VisemeEventComparator
    implements Comparator<VisemeEvent> {
        VisemeEventComparator() {
        }

        @Override
        public int compare(VisemeEvent o1, VisemeEvent o2) {
            long t2;
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            long t1 = o1.getTimestampMillisecUTC();
            return t1 > (t2 = o2.getTimestampMillisecUTC()) ? 1 : (t1 < t2 ? -1 : 0);
        }
    }
}

