/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.speech.messaging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.core.Listener;
import org.robokind.api.common.utils.EventRepeater;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.messaging.MessageAsyncReceiver;
import org.robokind.api.messaging.MessageSender;
import org.robokind.api.messaging.services.DefaultServiceClient;
import org.robokind.api.messaging.services.ServiceCommand;
import org.robokind.api.messaging.services.ServiceCommandFactory;
import org.robokind.api.messaging.services.ServiceError;
import org.robokind.api.speech.SpeechEvent;
import org.robokind.api.speech.SpeechEventList;
import org.robokind.api.speech.SpeechRequest;
import org.robokind.api.speech.SpeechRequestFactory;
import org.robokind.api.speech.SpeechService;
import org.robokind.api.speech.utils.SpeechEventNotifier;

public class RemoteSpeechServiceClient<Conf>
extends DefaultServiceClient<Conf>
implements SpeechService {
    private static final Logger theLogger = Logger.getLogger(RemoteSpeechServiceClient.class.getName());
    private String mySpeechServiceId;
    private MessageSender<SpeechRequest> myRequestSender;
    private MessageAsyncReceiver<SpeechEventList> myEventReceiver;
    private SpeechEventNotifier mySpeechEventNotifier;
    private SpeechRequestFactory myRequestFactory;
    private EventRepeater<SpeechRequest> myRequestRepeater;

    public RemoteSpeechServiceClient(Class<Conf> configClass, String speechServiceId, String remoteId, MessageSender<ServiceCommand> commandSender, MessageSender<Conf> configSender, MessageAsyncReceiver<ServiceError> errorReceiver, ServiceCommandFactory commandFactory, MessageSender<SpeechRequest> requestSender, MessageAsyncReceiver<SpeechEventList> eventReceiver, SpeechRequestFactory requestFactory) {
        super(speechServiceId, remoteId, commandSender, configSender, errorReceiver, commandFactory);
        if (speechServiceId == null) {
            throw new NullPointerException();
        }
        this.mySpeechServiceId = speechServiceId;
        this.mySpeechEventNotifier = new SpeechEventNotifier();
        this.myRequestSender = requestSender;
        this.myRequestRepeater = new EventRepeater();
        if (this.myRequestSender != null) {
            this.myRequestSender.addListener(this.myRequestRepeater);
        }
        this.myRequestFactory = requestFactory;
        this.myEventReceiver = eventReceiver;
        if (this.myEventReceiver != null) {
            this.myEventReceiver.addListener((Listener)this.mySpeechEventNotifier);
        }
    }

    @Override
    public String getSpeechServiceId() {
        return this.mySpeechServiceId;
    }

    @Override
    public void start() throws Exception {
        this.start(TimeUtils.now());
    }

    @Override
    public void speak(String text) {
        if (text == null) {
            throw new NullPointerException();
        }
        if (this.myRequestSender == null || this.myRequestFactory == null) {
            theLogger.warning("Unable to send speech request, Request Sender or Factory is null.");
            return;
        }
        theLogger.log(Level.INFO, "Speaking: {0}", text);
        SpeechRequest req = this.myRequestFactory.create(this.getClientId(), this.getHostId(), text);
        this.myRequestSender.notifyListeners((Object)req);
    }

    @Override
    public void cancelSpeech() {
        this.send("cancelSpeech");
    }

    @Override
    public void stop() {
        super.stop(TimeUtils.now());
        this.myEventReceiver.stop();
        this.myRequestSender.stop();
    }

    public void setSpeechRequestSender(MessageSender<SpeechRequest> sender) {
        if (this.myRequestSender != null) {
            this.myRequestSender.removeListener(this.myRequestRepeater);
        }
        this.myRequestSender = sender;
        if (this.myRequestSender != null) {
            this.myRequestSender.addListener(this.myRequestRepeater);
        }
    }

    public void setSpeechEventsReceiver(MessageAsyncReceiver<SpeechEventList> receiver) {
        if (this.myEventReceiver != null) {
            this.myEventReceiver.removeListener((Listener)this.mySpeechEventNotifier);
        }
        this.myEventReceiver = receiver;
        if (this.myEventReceiver != null) {
            this.myEventReceiver.addListener((Listener)this.mySpeechEventNotifier);
        }
    }

    public void setSpeechRequestFactory(SpeechRequestFactory factory) {
        this.myRequestFactory = factory;
    }

    @Override
    public void addRequestListener(Listener<SpeechRequest> listener) {
        this.myRequestRepeater.addListener(listener);
    }

    @Override
    public void removeRequestListener(Listener<SpeechRequest> listener) {
        this.myRequestRepeater.removeListener(listener);
    }

    @Override
    public void addSpeechEventListener(Listener<SpeechEvent> listener) {
        this.mySpeechEventNotifier.addSpeechEventListener(listener);
    }

    @Override
    public void removeSpeechEventListener(Listener<SpeechEvent> listener) {
        this.mySpeechEventNotifier.removeSpeechEventListener(listener);
    }
}

