/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.speech.utils;

import java.util.ArrayList;
import java.util.List;
import org.jflux.api.core.Listener;
import org.robokind.api.speech.SpeechEvent;
import org.robokind.api.speech.SpeechEventList;

public class SpeechEventNotifier
implements Listener<SpeechEventList> {
    private List<Listener<SpeechEvent>> mySpeechEventListeners = new ArrayList<Listener<SpeechEvent>>();

    public void handleEvent(SpeechEventList t) {
        if (t == null || t.getSpeechEvents() == null) {
            throw new NullPointerException();
        }
        for (SpeechEvent ev : t.getSpeechEvents()) {
            if (ev == null) {
                throw new NullPointerException();
            }
            this.fireSpeechEvent(ev);
        }
    }

    public void fireSpeechEvent(SpeechEvent ev) {
        for (Listener<SpeechEvent> listener : this.mySpeechEventListeners) {
            listener.handleEvent((Object)ev);
        }
    }

    public void addSpeechEventListener(Listener<SpeechEvent> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (!this.mySpeechEventListeners.contains(listener)) {
            this.mySpeechEventListeners.add(listener);
        }
    }

    public void removeSpeechEventListener(Listener<SpeechEvent> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.mySpeechEventListeners.contains(listener)) {
            this.mySpeechEventListeners.remove(listener);
        }
    }
}

