/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.speech.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.core.Listener;
import org.robokind.api.speech.SpeechEvent;
import org.robokind.api.speech.SpeechEventList;
import org.robokind.api.speech.SpeechJob;
import org.robokind.api.speech.SpeechService;
import org.robokind.api.speech.utils.DefaultSpeechJob;

public class SpeechJobManager {
    private static final Logger theLogger = Logger.getLogger(SpeechJobManager.class.getName());
    private SpeechService mySpeechProxy;
    private Map<Long, SpeechJob> mySpeechJobs;
    private long myCurrentSpeechJobId;
    private SpeechEventListener myEventListener;

    public SpeechJobManager(SpeechService speechProxy) {
        if (speechProxy == null) {
            throw new NullPointerException();
        }
        this.mySpeechProxy = speechProxy;
        this.mySpeechJobs = new HashMap<Long, SpeechJob>();
        this.myCurrentSpeechJobId = -1L;
        this.myEventListener = new SpeechEventListener();
        this.mySpeechProxy.addSpeechEventListener(this.myEventListener);
    }

    public SpeechJob createSpeechJob(String text) {
        DefaultSpeechJob job = new DefaultSpeechJob(this, text);
        this.mySpeechJobs.put(job.getSpeechJobId(), job);
        return job;
    }

    void cancelSpeechJob(SpeechJob job) {
        if (this.myCurrentSpeechJobId == -1L || this.myCurrentSpeechJobId == job.getSpeechJobId()) {
            this.mySpeechProxy.cancelSpeech();
        }
    }

    private final class SpeechEventListener
    implements Listener<SpeechEventList<SpeechEvent>> {
        private SpeechEventListener() {
        }

        public synchronized void handleEvent(SpeechEventList<SpeechEvent> t) {
            if (t == null) {
                return;
            }
            for (SpeechEvent event : t.getSpeechEvents()) {
                this.handleSingleEvent(event);
            }
        }

        private void handleSingleEvent(SpeechEvent t) {
            if (t == null) {
                return;
            }
            String eventType = t.getEventType();
            if ("SPEECH_START".equals(eventType)) {
                long id = SpeechJobManager.this.myCurrentSpeechJobId + 1L;
                SpeechJob job = (SpeechJob)SpeechJobManager.this.mySpeechJobs.get(id);
                if (job == null) {
                    theLogger.log(Level.WARNING, "Unable to find RsSpeechJob with id={0}.  Ignoring SPEECH_START event.", id);
                    return;
                }
                if (3 == job.getStatus()) {
                    SpeechJobManager.this.mySpeechProxy.cancelSpeech();
                    return;
                }
                job.setStatus(1);
                this.completeOldJobs();
                SpeechJobManager.this.myCurrentSpeechJobId = id;
            } else if ("SPEECH_END".equals(eventType)) {
                SpeechJob job = (SpeechJob)SpeechJobManager.this.mySpeechJobs.get(SpeechJobManager.this.myCurrentSpeechJobId);
                if (job == null) {
                    theLogger.log(Level.WARNING, "Unable to find RsSpeechJob with id={0}.  Ignoring SPEECH_START event.", SpeechJobManager.this.myCurrentSpeechJobId);
                }
                this.completeOldJobs();
            }
        }

        private void completeOldJobs() {
            for (long id = SpeechJobManager.this.myCurrentSpeechJobId; id >= 0L; --id) {
                SpeechJob job = (SpeechJob)SpeechJobManager.this.mySpeechJobs.get(id);
                if (job == null) {
                    return;
                }
                int status = job.getStatus();
                if (status == 2) {
                    return;
                }
                if (status != 0 && status != 1) continue;
                job.setStatus(2);
            }
        }
    }
}

