/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.speech.viseme;

import java.util.EnumMap;
import java.util.Map;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.utils.Utils;
import org.robokind.api.speech.viseme.Viseme;
import org.robokind.api.speech.viseme.VisemePosition;
import org.robokind.api.speech.viseme.config.VisemeBindingConfig;

public class VisemeBinding {
    private int myBindingKey;
    private Map<Viseme, NormalizedDouble> myVisemeValueMap;

    public VisemeBinding(int key) {
        this.myBindingKey = key;
        this.myVisemeValueMap = new EnumMap<Viseme, NormalizedDouble>(Viseme.class);
    }

    public VisemeBinding(VisemeBindingConfig<VisemePosition> config) {
        this(config.getBindingId());
        for (VisemePosition pos : config.getVisemeBindings()) {
            int id = pos.getVisemeId();
            Viseme vis = Viseme.getById(id);
            double boundPos = Utils.bound((double)pos.getPosition(), (double)0.0, (double)1.0);
            NormalizedDouble val = new NormalizedDouble(boundPos);
            this.myVisemeValueMap.put(vis, val);
        }
    }

    public int getBindingKey() {
        return this.myBindingKey;
    }

    public NormalizedDouble getValue(Viseme viseme) {
        if (viseme == null) {
            throw new NullPointerException();
        }
        return this.myVisemeValueMap.get((Object)viseme);
    }

    public void setVisemeValue(Viseme viseme, NormalizedDouble value) {
        if (viseme == null) {
            throw new NullPointerException();
        }
        this.myVisemeValueMap.put(viseme, value);
    }

    public Map<Viseme, NormalizedDouble> getVisemeValueMap() {
        return this.myVisemeValueMap;
    }
}

