/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.speech.viseme;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.speech.viseme.Viseme;
import org.robokind.api.speech.viseme.VisemeBinding;

public class VisemeBindingManager {
    public static final String VERSION_NAME = "VisemeBindingManager";
    public static final String VERSION_NUMBER = "1.0";
    public static final VersionProperty VERSION = new VersionProperty("VisemeBindingManager", "1.0");
    private List<VisemeBinding> myBindings = new ArrayList<VisemeBinding>();

    public void addBinding(VisemeBinding binding) {
        if (binding == null) {
            throw new NullPointerException();
        }
        int i = this.getBindingIndex(binding.getBindingKey());
        if (i != -1) {
            this.myBindings.remove(i);
        }
        this.myBindings.add(binding);
    }

    private int getBindingIndex(int key) {
        int i = 0;
        for (VisemeBinding binding : this.myBindings) {
            if (binding.getBindingKey() == key) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Map<Integer, NormalizedDouble> getBindingValues(Viseme viseme) {
        if (viseme == null) {
            throw new NullPointerException();
        }
        HashMap<Integer, NormalizedDouble> map = new HashMap<Integer, NormalizedDouble>();
        for (VisemeBinding binding : this.myBindings) {
            map.put(binding.getBindingKey(), binding.getValue(viseme));
        }
        return map;
    }
}

