/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.speech.messaging;

import org.jflux.api.core.Listener;
import org.jflux.api.core.Notifier;
import org.robokind.api.speech.SpeechEvent;
import org.robokind.api.speech.SpeechEventList;
import org.robokind.api.speech.SpeechRequest;
import org.robokind.api.speech.SpeechService;

public class RemoteSpeechServiceHost
implements Listener<SpeechRequest> {
    private SpeechService mySpeechService;
    private Notifier<SpeechRequest> mySpeechRequestNotifier;
    private Listener<SpeechEventList<SpeechEvent>> mySpeechEventListener;
    public static final String PROP_ID = "speechServiceHostId";

    public RemoteSpeechServiceHost() {
        this.mySpeechService = null;
        this.mySpeechRequestNotifier = null;
        this.mySpeechEventListener = null;
    }

    public RemoteSpeechServiceHost(SpeechService service, Notifier<SpeechRequest> notifier, Listener<SpeechEventList<SpeechEvent>> listener) {
        this.mySpeechService = service;
        this.mySpeechRequestNotifier = notifier;
        this.mySpeechEventListener = listener;
        if (this.mySpeechEventListener != null && this.mySpeechService != null) {
            this.mySpeechService.addSpeechEventListener(this.mySpeechEventListener);
        }
        if (this.mySpeechRequestNotifier != null) {
            this.mySpeechRequestNotifier.addListener((Listener)this);
        }
    }

    public void setSpeechService(SpeechService service) {
        if (this.mySpeechEventListener != null && this.mySpeechService != null) {
            this.mySpeechService.removeSpeechEventListener(this.mySpeechEventListener);
        }
        this.mySpeechService = service;
        if (this.mySpeechEventListener != null && this.mySpeechService != null) {
            this.mySpeechService.addSpeechEventListener(this.mySpeechEventListener);
        }
    }

    public void setSpeechRequestNotifier(Notifier<SpeechRequest> notifier) {
        if (this.mySpeechRequestNotifier != null) {
            this.mySpeechRequestNotifier.removeListener((Listener)this);
        }
        this.mySpeechRequestNotifier = notifier;
        if (this.mySpeechRequestNotifier != null) {
            this.mySpeechRequestNotifier.addListener((Listener)this);
        }
    }

    public void setSpeechEventListener(Listener<SpeechEventList<SpeechEvent>> listener) {
        if (this.mySpeechEventListener != null && this.mySpeechService != null) {
            this.mySpeechService.removeSpeechEventListener(this.mySpeechEventListener);
        }
        this.mySpeechEventListener = listener;
        if (this.mySpeechEventListener != null && this.mySpeechService != null) {
            this.mySpeechService.addSpeechEventListener(this.mySpeechEventListener);
        }
    }

    public void handleEvent(SpeechRequest t) {
        if (this.mySpeechService != null) {
            this.mySpeechService.speak(t.getPhrase());
        }
    }
}

