/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.speech.utils;

import org.jflux.api.core.playable.Playable;
import org.jflux.api.core.util.DefaultNotifier;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.speech.SpeechJob;
import org.robokind.api.speech.utils.SpeechJobManager;

public class DefaultSpeechJob
extends DefaultNotifier<Playable.PlayState>
implements SpeechJob {
    public static final int PENDING = 0;
    public static final int RUNNING = 1;
    public static final int COMPLETE = 2;
    public static final int CANCELED = 3;
    private final long myJobId;
    private final String myText;
    private final long myStartTime;
    private int myStatus;
    private SpeechJobManager myManager;
    private static long theNextId = 0L;

    DefaultSpeechJob(SpeechJobManager manager, String text) {
        if (text == null) {
            throw new NullPointerException();
        }
        this.myJobId = DefaultSpeechJob.nextId();
        this.myStartTime = TimeUtils.now();
        this.myText = text;
        this.myStatus = 0;
        this.myManager = manager;
    }

    @Override
    public long getSpeechJobId() {
        return this.myJobId;
    }

    @Override
    public String getSpeechText() {
        return this.myText;
    }

    @Override
    public long getStartTime() {
        return this.myStartTime;
    }

    @Override
    public int getStatus() {
        return this.myStatus;
    }

    @Override
    public void setStatus(int status) {
        this.myStatus = status;
        if (status == 3 && this.myManager != null) {
            this.myManager.cancelSpeechJob(this);
        }
        this.notifyListeners(status == 0 ? Playable.PlayState.PENDING : (status == 1 ? Playable.PlayState.RUNNING : (status == 2 ? Playable.PlayState.COMPLETED : Playable.PlayState.ABORTED)));
    }

    @Override
    public void cancel() {
        this.setStatus(3);
        if (this.myManager != null) {
            this.myManager.cancelSpeechJob(this);
        }
    }

    private static synchronized long nextId() {
        return theNextId++;
    }
}

