/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.speech.viseme.config;

import java.util.List;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.services.ServiceFactory;
import org.robokind.api.speech.viseme.VisemeBinding;
import org.robokind.api.speech.viseme.VisemeBindingManager;
import org.robokind.api.speech.viseme.VisemePosition;
import org.robokind.api.speech.viseme.config.VisemeBindingConfig;
import org.robokind.api.speech.viseme.config.VisemeBindingManagerConfig;

public class VisemeBindingManagerFactory
implements ServiceFactory<VisemeBindingManager, VisemeBindingManagerConfig> {
    public static VisemeBindingManager buildManager(VisemeBindingManagerConfig config) {
        if (config == null) {
            throw new NullPointerException();
        }
        VisemeBindingManager manager = new VisemeBindingManager();
        List configs = config.getVisemeBindings();
        if (configs == null) {
            throw new NullPointerException();
        }
        for (VisemeBindingConfig bindingConfig : configs) {
            manager.addBinding(VisemeBindingManagerFactory.buildVisemeBinding(bindingConfig));
        }
        return manager;
    }

    protected static VisemeBinding buildVisemeBinding(VisemeBindingConfig<VisemePosition> config) {
        if (config == null) {
            throw new NullPointerException();
        }
        VisemeBinding vb = new VisemeBinding(config);
        return vb;
    }

    public VersionProperty getServiceVersion() {
        return VisemeBindingManager.VERSION;
    }

    public VisemeBindingManager build(VisemeBindingManagerConfig config) {
        return VisemeBindingManagerFactory.buildManager(config);
    }

    public Class<VisemeBindingManager> getServiceClass() {
        return VisemeBindingManager.class;
    }

    public Class<VisemeBindingManagerConfig> getConfigurationClass() {
        return VisemeBindingManagerConfig.class;
    }
}

