/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.speech.lifecycle;

import java.util.Map;
import java.util.Properties;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Notifier;
import org.jflux.impl.services.rk.lifecycle.AbstractLifecycleProvider;
import org.jflux.impl.services.rk.lifecycle.utils.DescriptorListBuilder;
import org.robokind.api.speech.SpeechEvent;
import org.robokind.api.speech.SpeechEventList;
import org.robokind.api.speech.SpeechRequest;
import org.robokind.api.speech.SpeechService;
import org.robokind.api.speech.messaging.RemoteSpeechServiceHost;

public class RemoteSpeechServiceHostLifecycle
extends AbstractLifecycleProvider<RemoteSpeechServiceHost, RemoteSpeechServiceHost> {
    private static final String theSpeechService = "speechService";
    private static final String theSpeechRequestNotifier = "speechRequestNotifier";
    private static final String theSpeechEventListener = "speechEventListener";
    private String myLocalServiceId;
    private String myRemoteServiceId;

    public RemoteSpeechServiceHostLifecycle(String speechServiceHostId, String remoteId, String speechServiceId, String speechRequestNotifierId, String speechEventListenerId) {
        super(new DescriptorListBuilder().dependency(theSpeechService, SpeechService.class).with("speechServiceId", speechServiceId).dependency(theSpeechRequestNotifier, Notifier.class).with("messageReceiverId", speechRequestNotifierId).with("messageType", SpeechRequest.class.getName()).dependency(theSpeechEventListener, Listener.class).with("messageSenderId", speechEventListenerId).with("messageType", SpeechEventList.class.getName()).getDescriptors());
        if (speechServiceHostId == null || remoteId == null) {
            throw new NullPointerException();
        }
        this.myLocalServiceId = speechServiceHostId;
        this.myRemoteServiceId = remoteId;
        this.myRegistrationProperties = new Properties();
        this.myRegistrationProperties.put("speechServiceHostId", this.myLocalServiceId);
    }

    protected RemoteSpeechServiceHost create(Map<String, Object> dependencies) {
        SpeechService service = (SpeechService)dependencies.get(theSpeechService);
        Notifier notifier = (Notifier)dependencies.get(theSpeechRequestNotifier);
        Listener listener = (Listener)dependencies.get(theSpeechEventListener);
        return new RemoteSpeechServiceHost(service, (Notifier<SpeechRequest>)notifier, (Listener<SpeechEventList<SpeechEvent>>)listener);
    }

    protected void handleChange(String name, Object dependency, Map<String, Object> availableDependencies) {
        if (theSpeechService.equals(name)) {
            ((RemoteSpeechServiceHost)this.myService).setSpeechService((SpeechService)dependency);
        } else if (theSpeechRequestNotifier.equals(name)) {
            ((RemoteSpeechServiceHost)this.myService).setSpeechRequestNotifier((Notifier<SpeechRequest>)((Notifier)dependency));
        } else if (theSpeechEventListener.equals(name)) {
            ((RemoteSpeechServiceHost)this.myService).setSpeechEventListener((Listener<SpeechEventList<SpeechEvent>>)((Listener)dependency));
        }
    }

    protected Class<RemoteSpeechServiceHost> getServiceClass() {
        return RemoteSpeechServiceHost.class;
    }
}

