/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.speechrec.lifecycle;

import java.util.Map;
import java.util.Properties;
import org.robokind.api.common.lifecycle.AbstractLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.DescriptorListBuilder;
import org.robokind.api.messaging.MessageAsyncReceiver;
import org.robokind.api.messaging.MessageSender;
import org.robokind.api.messaging.services.ServiceCommand;
import org.robokind.api.messaging.services.ServiceCommandFactory;
import org.robokind.api.messaging.services.ServiceError;
import org.robokind.api.speechrec.SpeechRecEventList;
import org.robokind.api.speechrec.SpeechRecService;
import org.robokind.api.speechrec.messaging.RemoteSpeechRecServiceClient;

public class RemoteSpeechRecServiceLifecycle<Conf>
extends AbstractLifecycleProvider<SpeechRecService, RemoteSpeechRecServiceClient> {
    private static final String theCommandSender = "commandSender";
    private static final String theConfigSender = "configSender";
    private static final String theErrorReceiver = "errorReceiver";
    private static final String theCommandFactory = "commandFactory";
    private static final String theSpeechRecReceiver = "speechRecReceiver";
    private String myClientServiceId;
    private String myHostServiceId;
    private Class<Conf> myConfigClass;

    public RemoteSpeechRecServiceLifecycle(Class<Conf> configClass, String speechRecServiceId, String remoteId, String commandSenderId, String configSenderId, String errorReceiverId, String requestSenderId, String eventsReceiverId) {
        super(new DescriptorListBuilder().dependency(theCommandSender, MessageSender.class).with("messageSenderId", commandSenderId).with("messageType", ServiceCommand.class.getName()).dependency(theConfigSender, MessageSender.class).with("messageSenderId", configSenderId).with("messageType", configClass.getName()).dependency(theErrorReceiver, MessageAsyncReceiver.class).with("messageReceiverId", errorReceiverId).with("messageType", ServiceError.class.getName()).dependency(theSpeechRecReceiver, MessageAsyncReceiver.class).with("messageReceiverId", eventsReceiverId).with("messageType", SpeechRecEventList.class.getName()).dependency(theCommandFactory, ServiceCommandFactory.class).getDescriptors());
        if (speechRecServiceId == null || remoteId == null) {
            throw new NullPointerException();
        }
        this.myClientServiceId = speechRecServiceId;
        this.myHostServiceId = remoteId;
        this.myRegistrationProperties = new Properties();
        this.myRegistrationProperties.put("speechRecServiceId", this.myClientServiceId);
    }

    protected RemoteSpeechRecServiceClient create(Map<String, Object> services) {
        MessageSender commandSender = (MessageSender)services.get(theCommandSender);
        MessageSender configSender = (MessageSender)services.get(theConfigSender);
        MessageAsyncReceiver errorReceiver = (MessageAsyncReceiver)services.get(theErrorReceiver);
        ServiceCommandFactory commandFactory = (ServiceCommandFactory)services.get(theCommandFactory);
        MessageAsyncReceiver speechRecReceiver = (MessageAsyncReceiver)services.get(theSpeechRecReceiver);
        return new RemoteSpeechRecServiceClient<Conf>(this.myConfigClass, this.myClientServiceId, this.myHostServiceId, (MessageSender<ServiceCommand>)commandSender, configSender, (MessageAsyncReceiver<ServiceError>)errorReceiver, commandFactory, (MessageAsyncReceiver<SpeechRecEventList>)speechRecReceiver);
    }

    protected void handleChange(String name, Object dependency, Map<String, Object> availableDependencies) {
        if (this.myService == null) {
            return;
        }
        if (theCommandSender.equals(name)) {
            ((RemoteSpeechRecServiceClient)this.myService).setCommandSender((MessageSender)dependency);
        } else if (theConfigSender.equals(name)) {
            ((RemoteSpeechRecServiceClient)this.myService).setConfigSender((MessageSender)dependency);
        } else if (theErrorReceiver.equals(name)) {
            ((RemoteSpeechRecServiceClient)this.myService).setErrorReceiver((MessageAsyncReceiver)dependency);
        } else if (theCommandFactory.equals(name)) {
            ((RemoteSpeechRecServiceClient)this.myService).setCommandFactory((ServiceCommandFactory)dependency);
        } else if (theSpeechRecReceiver.equals(name)) {
            ((RemoteSpeechRecServiceClient)this.myService).setSpeechRecReceiver((MessageAsyncReceiver<SpeechRecEventList>)((MessageAsyncReceiver)dependency));
        }
    }

    public Class<SpeechRecService> getServiceClass() {
        return SpeechRecService.class;
    }
}

