/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.speechrec.messaging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.core.Listener;
import org.jflux.api.messaging.rk.MessageAsyncReceiver;
import org.jflux.api.messaging.rk.MessageSender;
import org.robokind.api.common.playable.PlayState;
import org.robokind.api.common.utils.EventRepeater;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.messaging.services.DefaultServiceClient;
import org.robokind.api.messaging.services.ServiceCommand;
import org.robokind.api.messaging.services.ServiceCommandFactory;
import org.robokind.api.messaging.services.ServiceError;
import org.robokind.api.speechrec.SpeechRecEventList;
import org.robokind.api.speechrec.SpeechRecService;

public class RemoteSpeechRecServiceClient<Conf>
extends DefaultServiceClient<Conf>
implements SpeechRecService {
    private static final Logger theLogger = Logger.getLogger(RemoteSpeechRecServiceClient.class.getName());
    private String mySpeechRecServiceId;
    private MessageAsyncReceiver<SpeechRecEventList> mySpeechRecReceiver;
    private EventRepeater<SpeechRecEventList> mySpeechRecEventRepeater;

    public RemoteSpeechRecServiceClient(Class<Conf> configClass, String speechRecServiceId, String remoteId, MessageSender<ServiceCommand> commandSender, MessageSender<Conf> configSender, MessageAsyncReceiver<ServiceError> errorReceiver, ServiceCommandFactory commandFactory, MessageAsyncReceiver<SpeechRecEventList> speechRecReceiver) {
        super(speechRecServiceId, remoteId, commandSender, configSender, errorReceiver, commandFactory);
        if (speechRecServiceId == null) {
            throw new NullPointerException();
        }
        this.mySpeechRecServiceId = speechRecServiceId;
        this.mySpeechRecReceiver = speechRecReceiver;
        this.mySpeechRecEventRepeater = new EventRepeater();
    }

    @Override
    public String getSpeechRecServiceId() {
        return this.mySpeechRecServiceId;
    }

    @Override
    public void start() {
        this.start(TimeUtils.now());
        if (this.mySpeechRecReceiver != null) {
            this.mySpeechRecReceiver.addListener(this.mySpeechRecEventRepeater);
        }
    }

    @Override
    public void stop() {
        super.stop(TimeUtils.now());
    }

    public boolean onComplete(long time) {
        return this.playStateChange(super.onStop(time), PlayState.COMPLETED);
    }

    public boolean onPause(long time) {
        return this.playStateChange(super.onStop(time), PlayState.PAUSED);
    }

    public boolean onResume(long time) {
        return this.playStateChange(super.onStop(time), PlayState.RUNNING);
    }

    public boolean onStart(long time) {
        return this.playStateChange(super.onStop(time), PlayState.RUNNING);
    }

    public boolean onStop(long time) {
        return this.playStateChange(super.onStop(time), PlayState.STOPPED);
    }

    private boolean playStateChange(boolean attempt, PlayState state) {
        if (!attempt) {
            return false;
        }
        if (this.mySpeechRecReceiver == null) {
            theLogger.log(Level.INFO, "PlayState changed to {0}, but SpeechRecReceiver is null.", state);
            return true;
        }
        if (state == PlayState.RUNNING) {
            theLogger.log(Level.INFO, "PlayState changed to {0}, adding repeater to SpeechRecReceiver.", state);
            this.mySpeechRecReceiver.addListener(this.mySpeechRecEventRepeater);
        } else {
            theLogger.log(Level.INFO, "PlayState changed to {0}, removing repeater from SpeechRecReceiver.", state);
            this.mySpeechRecReceiver.removeListener(this.mySpeechRecEventRepeater);
        }
        return true;
    }

    public void setSpeechRecReceiver(MessageAsyncReceiver<SpeechRecEventList> receiver) {
        if (this.mySpeechRecReceiver != null) {
            this.mySpeechRecReceiver.removeListener(this.mySpeechRecEventRepeater);
        }
        this.mySpeechRecReceiver = receiver;
        if (this.mySpeechRecReceiver != null && PlayState.RUNNING == this.getPlayState()) {
            this.mySpeechRecReceiver.addListener(this.mySpeechRecEventRepeater);
        }
    }

    @Override
    public void addSpeechRecListener(Listener<SpeechRecEventList> listener) {
        this.mySpeechRecEventRepeater.addListener(listener);
    }

    @Override
    public void removeSpeechRecListener(Listener<SpeechRecEventList> listener) {
        this.mySpeechRecEventRepeater.removeListener(listener);
    }
}

