/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.vision.lifecycle;

import java.util.Map;
import java.util.Properties;
import org.robokind.api.common.lifecycle.AbstractLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.DescriptorListBuilder;
import org.robokind.api.messaging.MessageAsyncReceiver;
import org.robokind.api.messaging.MessageSender;
import org.robokind.api.messaging.services.ServiceCommand;
import org.robokind.api.messaging.services.ServiceCommandFactory;
import org.robokind.api.messaging.services.ServiceError;
import org.robokind.api.vision.ImageEvent;
import org.robokind.api.vision.ImageRegionList;
import org.robokind.api.vision.ImageService;
import org.robokind.api.vision.messaging.RemoteImageServiceClient;

public class RemoteImageServiceLifecycle<Conf>
extends AbstractLifecycleProvider<ImageService, RemoteImageServiceClient> {
    private static final String theCommandSender = "commandSender";
    private static final String theConfigSender = "configSender";
    private static final String theErrorReceiver = "errorReceiver";
    private static final String theCommandFactory = "commandFactory";
    private static final String theImageReceiver = "imageReceiver";
    private String myClientServiceId;
    private String myHostServiceId;
    private Class<Conf> myConfigClass;

    public RemoteImageServiceLifecycle(Class<Conf> configClass, String imageServiceId, String remoteId, String commandSenderId, String configSenderId, String errorReceiverId, String requestSenderId, String eventsReceiverId) {
        super(new DescriptorListBuilder().dependency(theCommandSender, MessageSender.class).with("messageSenderId", commandSenderId).with("messageType", ServiceCommand.class.getName()).dependency(theConfigSender, MessageSender.class).with("messageSenderId", configSenderId).with("messageType", configClass.getName()).dependency(theErrorReceiver, MessageAsyncReceiver.class).with("messageReceiverId", errorReceiverId).with("messageType", ServiceError.class.getName()).dependency(theImageReceiver, MessageAsyncReceiver.class).with("messageReceiverId", eventsReceiverId).with("messageType", ImageRegionList.class.getName()).dependency(theCommandFactory, ServiceCommandFactory.class).getDescriptors());
        if (imageServiceId == null || remoteId == null) {
            throw new NullPointerException();
        }
        this.myClientServiceId = imageServiceId;
        this.myHostServiceId = remoteId;
        this.myRegistrationProperties = new Properties();
        this.myRegistrationProperties.put("imageServiceId", this.myClientServiceId);
    }

    protected RemoteImageServiceClient create(Map<String, Object> services) {
        MessageSender commandSender = (MessageSender)services.get(theCommandSender);
        MessageSender configSender = (MessageSender)services.get(theConfigSender);
        MessageAsyncReceiver errorReceiver = (MessageAsyncReceiver)services.get(theErrorReceiver);
        ServiceCommandFactory commandFactory = (ServiceCommandFactory)services.get(theCommandFactory);
        MessageAsyncReceiver imageReceiver = (MessageAsyncReceiver)services.get(theImageReceiver);
        return new RemoteImageServiceClient<Conf>(this.myConfigClass, this.myClientServiceId, this.myHostServiceId, (MessageSender<ServiceCommand>)commandSender, configSender, (MessageAsyncReceiver<ServiceError>)errorReceiver, commandFactory, (MessageAsyncReceiver<ImageEvent>)imageReceiver);
    }

    protected void handleChange(String name, Object dependency, Map<String, Object> availableDependencies) {
        if (this.myService == null) {
            return;
        }
        if (theCommandSender.equals(name)) {
            ((RemoteImageServiceClient)this.myService).setCommandSender((MessageSender)dependency);
        } else if (theConfigSender.equals(name)) {
            ((RemoteImageServiceClient)this.myService).setConfigSender((MessageSender)dependency);
        } else if (theErrorReceiver.equals(name)) {
            ((RemoteImageServiceClient)this.myService).setErrorReceiver((MessageAsyncReceiver)dependency);
        } else if (theCommandFactory.equals(name)) {
            ((RemoteImageServiceClient)this.myService).setCommandFactory((ServiceCommandFactory)dependency);
        } else if (theImageReceiver.equals(name)) {
            ((RemoteImageServiceClient)this.myService).setImageReceiver((MessageAsyncReceiver<ImageEvent>)((MessageAsyncReceiver)dependency));
        }
    }

    public Class<ImageService> getServiceClass() {
        return ImageService.class;
    }
}

