/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.vision.messaging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.core.Listener;
import org.jflux.api.messaging.rk.MessageAsyncReceiver;
import org.jflux.api.messaging.rk.MessageSender;
import org.robokind.api.common.playable.PlayState;
import org.robokind.api.common.utils.EventRepeater;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.messaging.services.DefaultServiceClient;
import org.robokind.api.messaging.services.ServiceCommand;
import org.robokind.api.messaging.services.ServiceCommandFactory;
import org.robokind.api.messaging.services.ServiceError;
import org.robokind.api.vision.ImageEvent;
import org.robokind.api.vision.ImageService;

public class RemoteImageServiceClient<Conf>
extends DefaultServiceClient<Conf>
implements ImageService {
    private static final Logger theLogger = Logger.getLogger(RemoteImageServiceClient.class.getName());
    private String myImageServiceId;
    private MessageAsyncReceiver<ImageEvent> myImageReceiver;
    private EventRepeater<ImageEvent> myImageEventRepeater;

    public RemoteImageServiceClient(Class<Conf> configClass, String imageServiceId, String remoteId, MessageSender<ServiceCommand> commandSender, MessageSender<Conf> configSender, MessageAsyncReceiver<ServiceError> errorReceiver, ServiceCommandFactory commandFactory, MessageAsyncReceiver<ImageEvent> imageReceiver) {
        super(imageServiceId, remoteId, commandSender, configSender, errorReceiver, commandFactory);
        if (imageServiceId == null) {
            throw new NullPointerException();
        }
        this.myImageServiceId = imageServiceId;
        this.myImageReceiver = imageReceiver;
        this.myImageEventRepeater = new EventRepeater();
    }

    @Override
    public String getImageServiceId() {
        return this.myImageServiceId;
    }

    @Override
    public void start() {
        super.start(TimeUtils.now());
    }

    @Override
    public void stop() {
        super.stop(TimeUtils.now());
    }

    public boolean onComplete(long time) {
        return this.playStateChange(super.onComplete(time), PlayState.COMPLETED);
    }

    public boolean onPause(long time) {
        return this.playStateChange(super.onPause(time), PlayState.PAUSED);
    }

    public boolean onResume(long time) {
        return this.playStateChange(super.onResume(time), PlayState.RUNNING);
    }

    public boolean onStart(long time) {
        return this.playStateChange(super.onStart(time), PlayState.RUNNING);
    }

    public boolean onStop(long time) {
        return this.playStateChange(super.onStop(time), PlayState.STOPPED);
    }

    private boolean playStateChange(boolean attempt, PlayState state) {
        if (!attempt) {
            return false;
        }
        if (this.myImageReceiver == null) {
            theLogger.log(Level.INFO, "PlayState changed to {0}, but ImageReceiver is null.", state);
            return true;
        }
        if (state == PlayState.RUNNING) {
            theLogger.log(Level.INFO, "PlayState changed to {0}, adding repeater to ImageReceiver.", state);
            this.myImageReceiver.addListener(this.myImageEventRepeater);
        } else {
            theLogger.log(Level.INFO, "PlayState changed to {0}, removing repeater from ImageReceiver.", state);
            this.myImageReceiver.removeListener(this.myImageEventRepeater);
        }
        return true;
    }

    public void setImageReceiver(MessageAsyncReceiver<ImageEvent> receiver) {
        if (this.myImageReceiver != null) {
            this.myImageReceiver.removeListener(this.myImageEventRepeater);
        }
        this.myImageReceiver = receiver;
        if (this.myImageReceiver != null && PlayState.RUNNING == this.getPlayState()) {
            this.myImageReceiver.addListener(this.myImageEventRepeater);
        }
    }

    @Override
    public void addImageListener(Listener<ImageEvent> listener) {
        this.myImageEventRepeater.addListener(listener);
    }

    @Override
    public void removeImageListener(Listener<ImageEvent> listener) {
        this.myImageEventRepeater.removeListener(listener);
    }
}

