package org.robokind.avrogen.motion;

@SuppressWarnings("all")
public interface MotionProtocol {
  public static final org.apache.avro.Protocol PROTOCOL = org.apache.avro.Protocol.parse("{\"protocol\":\"MotionProtocol\",\"namespace\":\"org.robokind.avrogen.motion\",\"types\":[{\"type\":\"record\",\"name\":\"JointIdRecord\",\"fields\":[{\"name\":\"robotId\",\"type\":\"string\"},{\"name\":\"jointId\",\"type\":\"int\"}]},{\"type\":\"record\",\"name\":\"JointPositionRecord\",\"fields\":[{\"name\":\"jointId\",\"type\":\"JointIdRecord\"},{\"name\":\"normalizedPosition\",\"type\":\"double\"}]},{\"type\":\"record\",\"name\":\"RobotPositionMapRecord\",\"fields\":[{\"name\":\"jointPositions\",\"type\":{\"type\":\"array\",\"items\":\"JointPositionRecord\"}}]},{\"type\":\"record\",\"name\":\"MotionFrameRecord\",\"fields\":[{\"name\":\"timestampMillisecUTC\",\"type\":\"long\"},{\"name\":\"moveDurationMillisec\",\"type\":\"long\"},{\"name\":\"goalPositions\",\"type\":\"RobotPositionMapRecord\"},{\"name\":\"startPositions\",\"type\":[\"RobotPositionMapRecord\",\"null\"]}]},{\"type\":\"record\",\"name\":\"MotionFrameEventRecord\",\"fields\":[{\"name\":\"sourceId\",\"type\":\"string\"},{\"name\":\"destinationId\",\"type\":\"string\"},{\"name\":\"currentTimeMillisecUTC\",\"type\":\"long\"},{\"name\":\"motionFrame\",\"type\":\"MotionFrameRecord\"}]},{\"type\":\"record\",\"name\":\"SynchronizedJointConfigRecord\",\"fields\":[{\"name\":\"jointId\",\"type\":\"int\"},{\"name\":\"name\",\"type\":\"string\"},{\"name\":\"defaultPosition\",\"type\":[\"double\",\"null\"]}]},{\"type\":\"record\",\"name\":\"SynchronizedRobotConfigRecord\",\"fields\":[{\"name\":\"robotId\",\"type\":\"string\"},{\"name\":\"joints\",\"type\":{\"type\":\"array\",\"items\":\"SynchronizedJointConfigRecord\"}}]},{\"type\":\"record\",\"name\":\"RobotRequestRecord\",\"fields\":[{\"name\":\"robotId\",\"type\":\"string\"},{\"name\":\"requestSourceId\",\"type\":\"string\"},{\"name\":\"requestDestinationId\",\"type\":\"string\"},{\"name\":\"requestType\",\"type\":\"string\"},{\"name\":\"timestampMillisecUTC\",\"type\":\"long\"},{\"name\":\"intParam\",\"type\":[\"int\",\"null\"]}]},{\"type\":\"record\",\"name\":\"RobotResponseHeaderRecord\",\"fields\":[{\"name\":\"robotId\",\"type\":\"string\"},{\"name\":\"requestSourceId\",\"type\":\"string\"},{\"name\":\"requestDestinationId\",\"type\":\"string\"},{\"name\":\"requestType\",\"type\":\"string\"},{\"name\":\"requestTimestampMillisecUTC\",\"type\":\"long\"},{\"name\":\"responseTimestampMillisecUTC\",\"type\":\"long\"}]},{\"type\":\"record\",\"name\":\"RobotStatusResponseRecord\",\"fields\":[{\"name\":\"responseHeader\",\"type\":\"RobotResponseHeaderRecord\"},{\"name\":\"statusResponse\",\"type\":\"boolean\"}]},{\"type\":\"record\",\"name\":\"RobotPositionResponseRecord\",\"fields\":[{\"name\":\"responseHeader\",\"type\":\"RobotResponseHeaderRecord\"},{\"name\":\"positionResponse\",\"type\":\"RobotPositionMapRecord\"}]},{\"type\":\"record\",\"name\":\"JointDefinitionRecord\",\"fields\":[{\"name\":\"jointId\",\"type\":\"int\"},{\"name\":\"name\",\"type\":\"string\"},{\"name\":\"defaultPosition\",\"type\":\"double\"},{\"name\":\"goalPosition\",\"type\":\"double\"},{\"name\":\"enabled\",\"type\":\"boolean\"}]},{\"type\":\"record\",\"name\":\"RobotDefinitionResponseRecord\",\"fields\":[{\"name\":\"responseHeader\",\"type\":\"RobotResponseHeaderRecord\"},{\"name\":\"connected\",\"type\":\"boolean\"},{\"name\":\"enabled\",\"type\":\"boolean\"},{\"name\":\"joints\",\"type\":{\"type\":\"array\",\"items\":\"JointDefinitionRecord\"}}]}],\"messages\":{}}");
}
