/*
 * Copyright 2013 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.robokind.client.basic;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * Defines the joint ids for a Robokind Robot.
 * 
 * @author Matthew Stevenson <www.robokind.org>
 */
public final class RobotJoints {
    public final static int WAIST = 100;
    
    public final static int NECK_YAW = 200;
    public final static int NECK_ROLL = 201;
    public final static int NECK_PITCH = 202;
    
    public final static int BROWS = 300;
    public final static int EYELIDS = 301;
    public final static int EYES_PITCH = 310;
    public final static int LEFT_EYE_YAW = 311;
    public final static int RIGHT_EYE_YAW = 312;
    public final static int LEFT_SMILE = 320;
    public final static int RIGHT_SMILE = 321;
    public final static int JAW = 322;
    
    public final static int LEFT_SHOULDER_PITCH = 400;
    public final static int LEFT_SHOULDER_ROLL = 401;
    public final static int LEFT_ELBOW_YAW = 410;
    public final static int LEFT_ELBOW_PITCH = 411;
    public final static int LEFT_WRIST_YAW = 420;
    public final static int LEFT_HAND_GRASP = 421;
    
    public final static int RIGHT_SHOULDER_PITCH = 500;
    public final static int RIGHT_SHOULDER_ROLL = 501;
    public final static int RIGHT_ELBOW_YAW = 510;
    public final static int RIGHT_ELBOW_PITCH = 511;
    public final static int RIGHT_WRIST_YAW = 520;
    public final static int RIGHT_HAND_GRASP = 521;
    
    public final static int LEFT_HIP_ROLL = 600;
    public final static int LEFT_HIP_YAW = 601;
    public final static int LEFT_HIP_PITCH = 602;
    public final static int LEFT_KNEE_PITCH = 610;
    public final static int LEFT_ANKLE_PITCH = 620;
    public final static int LEFT_ANKLE_ROLL = 621;
    
    public final static int RIGHT_HIP_ROLL = 700;
    public final static int RIGHT_HIP_YAW = 701;
    public final static int RIGHT_HIP_PITCH = 702;
    public final static int RIGHT_KNEE_PITCH = 710;
    public final static int RIGHT_ANKLE_PITCH = 720;
    public final static int RIGHT_ANKLE_ROLL = 721;
    
    /**
     * Unmodifiable list containing all joint ids.
     */
    public final static List<Integer> ALL_JOINTS = 
            Collections.unmodifiableList(Arrays.asList(
                    WAIST, 
                    
                    NECK_YAW, NECK_ROLL, NECK_PITCH,
                    BROWS, EYELIDS, EYES_PITCH, LEFT_EYE_YAW, RIGHT_EYE_YAW, 
                    LEFT_SMILE, RIGHT_SMILE, JAW, 
                    
                    LEFT_SHOULDER_PITCH, LEFT_SHOULDER_ROLL, 
                    LEFT_ELBOW_YAW, LEFT_ELBOW_PITCH, 
                    LEFT_WRIST_YAW, LEFT_HAND_GRASP,
                    RIGHT_SHOULDER_PITCH, RIGHT_SHOULDER_ROLL, 
                    RIGHT_ELBOW_YAW, RIGHT_ELBOW_PITCH,
                    RIGHT_WRIST_YAW, RIGHT_HAND_GRASP, 
                    
                    LEFT_HIP_ROLL, LEFT_HIP_YAW, LEFT_HIP_PITCH, 
                    LEFT_KNEE_PITCH, LEFT_ANKLE_PITCH, LEFT_ANKLE_ROLL, 
                    RIGHT_HIP_ROLL, RIGHT_HIP_YAW, RIGHT_HIP_PITCH, 
                    RIGHT_KNEE_PITCH, RIGHT_ANKLE_PITCH, RIGHT_ANKLE_ROLL));
    
    private RobotJoints(){}
}
