/*
 * Copyright 2013 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.robokind.client.basic;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public final class UserSettings{
    private static String theRobotAddress = "127.0.0.1";
    private static String theAnimAddress = "127.0.0.1";
    private static String theSpeechAddress = "127.0.0.1";
    private static String theSensorAddress = "127.0.0.1";
    /**
     * Set the id of the robot to connect to.
     * Set to "myRobot" for connecting to a physical robot.
     * @param robotId robot id string
     */
    public static void setRobotId(String robotId){
        if(robotId == null){
            throw new NullPointerException();
        }
        RkRobotConnector.getConnector().setRobotId(robotId);
    }
    
    /**
     * Set the IP Address for the Robot or Avatar.
     * Default value is 127.0.0.1.
     * @param address IP address of the robot
     */
    public static void setRobotAddress(String address){
        if(address == null){
            throw new NullPointerException();
        }
        theRobotAddress = address;
    }
    /**
     * Returns the robot IP address.
     * @return robot IP address
     */
    static String getRobotAddress(){
        return theRobotAddress;
    }
    
    /**
     * Set the IP Address for the Robot or Avatar animation player.
     * Default value is 127.0.0.1.
     * @param address IP address of the animation player
     */
    public static void setAnimationAddress(String address){
        if(address == null){
            throw new NullPointerException();
        }
        theAnimAddress = address;
    }
    /**
     * Returns the animation player IP address.
     * @return animation player IP address
     */
    static String getAnimationAddress(){
        return theAnimAddress;
    }
    
    /**
     * Set the IP Address for the Robot or Avatar speech service.
     * Default value is 127.0.0.1.
     * @param address IP address of the speech service
     */
    public static void setSpeechAddress(String address){
        if(address == null){
            throw new NullPointerException();
        }
        theSpeechAddress = address;
    }
    /**
     * Returns the speech service IP address.
     * @return speech service IP address
     */
    static String getSpeechAddress(){
        return theSpeechAddress;
    }
    
    /**
     * Set the IP Address for the Robot or Avatar speech service.
     * Default value is 127.0.0.1.
     * @param address IP address of the speech service
     */
    public static void setSensorAddress(String address){
        if(address == null){
            throw new NullPointerException();
        }
        theSensorAddress = address;
    }
    /**
     * Returns the speech service IP address.
     * @return speech service IP address
     */
    static String getSensorAddress(){
        return theSensorAddress;
    }
}
