/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.client.basic;

import java.net.URISyntaxException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.jflux.api.core.Source;
import org.jflux.api.core.util.DefaultTimestampSource;
import org.jflux.api.core.util.EmptyAdapter;
import org.robokind.api.messaging.MessageAsyncReceiver;
import org.robokind.api.messaging.MessageSender;
import org.robokind.api.sensor.gpio.GpioService;
import org.robokind.api.sensor.gpio.RemoteGpioService;
import org.robokind.avrogen.sensor.DeviceBoolRecord;
import org.robokind.avrogen.sensor.HeaderRecord;
import org.robokind.client.basic.ConnectionContext;
import org.robokind.client.basic.RobotSensors;

final class RkSensorConnector
extends ConnectionContext.RkServiceConnector {
    static final String GPIO_VALUE_RECEIVER = "gpioValueReceiver";
    static final String GPIO_DIRECTION_SENDER = "gpioDirectionSender";
    static final String GPIO_VALUE_SENDER = "gpioValueSender";
    private static RkSensorConnector theRkSensorConnector;
    private String theGpioInputDest = "GpioEvent";
    private String theGpioDirectionDest = "GpioCommand";
    private String theGpioOutputDest = "GpioWriteCommand";

    RkSensorConnector() {
    }

    static synchronized RkSensorConnector getConnector() {
        if (theRkSensorConnector == null) {
            theRkSensorConnector = new RkSensorConnector();
        }
        return theRkSensorConnector;
    }

    @Override
    protected synchronized void addConnection(Session session) throws JMSException, URISyntaxException {
        if (this.myConnectionContext == null || this.myConnectionsFlag) {
            return;
        }
        Destination gpioValReceiver = ConnectionContext.getQueue(this.theGpioInputDest);
        this.myConnectionContext.addAsyncReceiver(GPIO_VALUE_RECEIVER, session, gpioValReceiver, DeviceBoolRecord.class, DeviceBoolRecord.SCHEMA$, new EmptyAdapter());
        Destination gpioDirSender = ConnectionContext.getQueue(this.theGpioDirectionDest);
        this.myConnectionContext.addSender(GPIO_DIRECTION_SENDER, session, gpioDirSender, new EmptyAdapter());
        Destination gpioValSender = ConnectionContext.getQueue(this.theGpioOutputDest);
        this.myConnectionContext.addSender(GPIO_VALUE_SENDER, session, gpioValSender, new EmptyAdapter());
        this.myConnectionsFlag = true;
    }

    synchronized RemoteGpioService buildRemoteClient() {
        if (this.myConnectionContext == null || !this.myConnectionsFlag) {
            return null;
        }
        MessageAsyncReceiver gpioValReceiver = this.myConnectionContext.getAsyncReceiver(GPIO_VALUE_RECEIVER);
        MessageSender gpioDirSender = this.myConnectionContext.getSender(GPIO_DIRECTION_SENDER);
        MessageSender gpioValSender = this.myConnectionContext.getSender(GPIO_VALUE_SENDER);
        HeaderRecord.Builder headerFact = HeaderRecord.newBuilder();
        headerFact.setFrameId(0);
        headerFact.setSequenceId(0);
        headerFact.setTimestamp(0L);
        HeaderRecord emptyHeader = headerFact.build();
        DeviceBoolRecord.Builder eventFact = DeviceBoolRecord.newBuilder();
        eventFact.setHeader(emptyHeader);
        eventFact.setChannelId(0);
        eventFact.setBoolValue(false);
        RemoteGpioService client = new RemoteGpioService((Source)headerFact, (Source)new DefaultTimestampSource(), (Source)eventFact, gpioDirSender, gpioValSender, gpioValReceiver, 0, 0, 0, new int[]{0, 1, 2, 3, 4, 5, 8, 9, 10, 11});
        return client;
    }

    static void initializeGpioClient(GpioService client) {
        client.setPinDirection(8, false);
        client.setPinValue(8, true);
        client.setPinDirection(10, false);
        client.setPinValue(10, true);
        for (int i : RobotSensors.ALL_GPIO_PINS) {
            client.setPinDirection(i, true);
        }
    }
}

