package org.robokind.client.basic;

import java.net.URISyntaxException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.robokind.api.messaging.MessageAsyncReceiver;
import org.robokind.api.messaging.MessageSender;
import org.robokind.api.messaging.services.ServiceCommand;
import org.robokind.api.messaging.services.ServiceError;
import org.robokind.avrogen.messaging.ServiceErrorRecord;
import org.robokind.impl.messaging.services.PortableServiceCommand;
import org.jflux.api.core.util.EmptyAdapter;
import org.robokind.api.vision.ImageEvent;
import org.robokind.api.vision.config.CameraServiceConfig;
import org.robokind.api.vision.config.FaceDetectServiceConfig;
import org.robokind.api.vision.messaging.RemoteImageRegionServiceClient;
import org.robokind.avrogen.vision.ImageRegionListRecord;
import org.robokind.client.basic.ConnectionContext.RkServiceConnector;

/**
 *
 * @author Jason G. Pallack <jgpallack@gmail.com>
 */
final class RkImageRegionConnector extends RkServiceConnector{
    final static String CMD_SENDER = "irCommandSender";
    final static String CONFIG_SENDER = "irConfigSender";
    final static String ERROR_RECEIVER = "irErrorReceiver";
    final static String EVENT_RECEIVER = "irEventReceiver";
    
    static RkImageRegionConnector theRkImageRegionConnector;
    
    private String myCommandDest = "visionproc0Command";
    private String myConfigDest = "visionproc0Command"; //Same as command
    private String myErrorDest = "visionproc0Error";
    private String myEventDest = "visionproc0Event";
    
    static synchronized RkImageRegionConnector getConnector(){
        if(theRkImageRegionConnector == null){
            theRkImageRegionConnector = new RkImageRegionConnector();
        }
        return theRkImageRegionConnector;
    }
    
    @Override
    protected synchronized void addConnection(Session session) 
            throws JMSException, URISyntaxException{
        if(myConnectionContext == null || myConnectionsFlag){
            return;
        }
        
        readCameraId();
        
        Destination cmdDest = ConnectionContext.getQueue(myCommandDest);
        Destination confDest = ConnectionContext.getQueue(myConfigDest);
        Destination errDest = ConnectionContext.getTopic(myErrorDest);
        Destination evtDest = ConnectionContext.getTopic(myEventDest);
        
        myConnectionContext.addSender(CMD_SENDER, session, cmdDest, 
                new EmptyAdapter());
        myConnectionContext.addSender(CONFIG_SENDER, session, confDest, 
                new EmptyAdapter());
        myConnectionContext.addAsyncReceiver(ERROR_RECEIVER, session, errDest,
                ServiceErrorRecord.class, ServiceErrorRecord.SCHEMA$,
                new EmptyAdapter());
        myConnectionContext.addAsyncReceiver(EVENT_RECEIVER, session, evtDest,
                ImageRegionListRecord.class, ImageRegionListRecord.SCHEMA$,
                new EmptyAdapter());
        
        myConnectionsFlag = true;
    }
    
    synchronized RemoteImageRegionServiceClient<FaceDetectServiceConfig> buildRemoteClient(){
        if(myConnectionContext == null || !myConnectionsFlag){
            return null;
        }
        MessageSender<ServiceCommand> cmdSender = 
                myConnectionContext.getSender(CMD_SENDER);
        MessageSender<CameraServiceConfig> confSender = 
                myConnectionContext.getSender(CONFIG_SENDER);
        MessageAsyncReceiver<ServiceError> errReceiver = 
                myConnectionContext.getAsyncReceiver(ERROR_RECEIVER);
        MessageAsyncReceiver<ImageEvent> evtReceiver = 
                myConnectionContext.getAsyncReceiver(EVENT_RECEIVER);
        
        RemoteImageRegionServiceClient<FaceDetectServiceConfig> client = 
                new RemoteImageRegionServiceClient(
                FaceDetectServiceConfig.class, "imageRegionServiceId",
                "remoteImageRegionServiceId", cmdSender, confSender,
                errReceiver, new PortableServiceCommand.Factory(), evtReceiver);
        
        return client;
    }

    private synchronized void readCameraId() {
        String cameraId = UserSettings.getImageRegionId();
        
        if(cameraId.equals("0")) {
            myCommandDest = myCommandDest.replace("1", cameraId);
            myConfigDest = myConfigDest.replace("1", cameraId);
            myErrorDest = myErrorDest.replace("1", cameraId);
            myEventDest = myEventDest.replace("1", cameraId);
        } else if(cameraId.equals("1")) {
            myCommandDest = myCommandDest.replace("0", cameraId);
            myConfigDest = myConfigDest.replace("0", cameraId);
            myErrorDest = myErrorDest.replace("0", cameraId);
            myEventDest = myEventDest.replace("0", cameraId);
        }
    }
}
