/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.client.basic;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.qpid.client.AMQAnyDestination;
import org.apache.qpid.client.AMQConnectionFactory;
import org.apache.qpid.url.URLSyntaxException;
import org.jflux.api.core.Adapter;
import org.robokind.api.messaging.DefaultMessageBlockingReceiver;
import org.robokind.api.messaging.MessageAsyncReceiver;
import org.robokind.api.messaging.MessageBlockingReceiver;
import org.robokind.api.messaging.MessageSender;
import org.robokind.api.messaging.RecordBlockingReceiver;
import org.robokind.client.basic.RkAnimationConnector;
import org.robokind.client.basic.RkRobotConnector;
import org.robokind.client.basic.RkSpeechConnector;
import org.robokind.client.basic.UserSettings;
import org.robokind.impl.messaging.JMSAvroMessageAsyncReceiver;
import org.robokind.impl.messaging.JMSAvroMessageSender;
import org.robokind.impl.messaging.JMSBytesRecordBlockingReceiver;
import org.robokind.impl.messaging.utils.ConnectionManager;

final class ConnectionContext {
    private static final Logger theLogger = Logger.getLogger(ConnectionContext.class.getName());
    static final String QUEUE = "queue";
    static final String TOPIC = "topic";
    private static ConnectionContext theConnectionContext;
    private List<Connection> myConnections = new ArrayList<Connection>();
    private List<MessengerContext> myMessengers = new ArrayList<MessengerContext>();
    private Map<String, SenderContext> mySenders = new HashMap<String, SenderContext>();
    private Map<String, AsyncReceiverContext> myAsyncReceivers = new HashMap<String, AsyncReceiverContext>();
    private Map<String, BlockingReceiverContext> myBlockingReceivers = new HashMap<String, BlockingReceiverContext>();

    static ConnectionContext getContext() {
        if (theConnectionContext == null) {
            theConnectionContext = new ConnectionContext();
        }
        return theConnectionContext;
    }

    static ConnectionContext createDefaultConnections() throws JMSException, URISyntaxException, URLSyntaxException {
        ConnectionContext context = ConnectionContext.getContext();
        context.addConnection(RkRobotConnector.getConnector(), UserSettings.getRobotAddress());
        context.addConnection(RkAnimationConnector.getConnector(), UserSettings.getAnimationAddress());
        context.addConnection(RkSpeechConnector.getConnector(), UserSettings.getSpeechAddress());
        return context;
    }

    void addConnection(RkServiceConnector connector, String ip) throws JMSException, URISyntaxException, URLSyntaxException {
        connector.setConnectionContext(this);
        Connection connection = ConnectionContext.connectDefault(ip);
        this.addConnection(connection);
        Session session = connection.createSession(false, 2);
        connector.addConnection(session);
    }

    private static Connection connectDefault(String ip) throws JMSException, URLSyntaxException {
        ConnectionConfig config = ConnectionConfig.makeDefault(ip);
        return ConnectionContext.createFromConfig(config);
    }

    private static Connection createFromConfig(ConnectionConfig config) throws JMSException, URLSyntaxException {
        return ConnectionContext.createConnection(config.getUsername(), config.getPassword(), config.getClientName(), config.getVirtualHost(), config.getIpAddress(), config.getPortNumber());
    }

    static Connection createConnection(String user, String pass, String client, String host, String ipAddr, String port) throws JMSException, URLSyntaxException {
        String tcp = "tcp://" + ipAddr + ":" + port;
        String amqpURL = ConnectionManager.createAMQPConnectionURL((String)user, (String)pass, (String)client, (String)host, (String)tcp);
        AMQConnectionFactory cf = new AMQConnectionFactory(amqpURL);
        return cf.createConnection();
    }

    static Destination getQueue(String dest) throws URISyntaxException {
        return ConnectionContext.getDestination(dest, QUEUE);
    }

    static Destination getTopic(String dest) throws URISyntaxException {
        return ConnectionContext.getDestination(dest, TOPIC);
    }

    static Destination getDestination(String dest, String type) throws URISyntaxException {
        String full = dest + "; {create: always, node: {type: " + type + "}}";
        return new AMQAnyDestination(full);
    }

    ConnectionContext() {
    }

    void addConnection(Connection con) {
        this.myConnections.add(con);
    }

    <M, R extends SpecificRecordBase> void addAsyncReceiver(String name, Session session, Destination destination, Class<R> recordClass, Schema recordSchema, Adapter<R, M> adapter) throws JMSException {
        AsyncReceiverContext<M, R> context = new AsyncReceiverContext<M, R>(name, session, destination, recordClass, recordSchema, adapter);
        this.myMessengers.add(context);
        this.myAsyncReceivers.put(name, context);
    }

    <M> void addBlockingPolyReceiver(String name, Session session, Destination destination, Adapter<BytesMessage, M> adapter) throws JMSException {
        BlockingReceiverContext<M> context = new BlockingReceiverContext<M>(name, session, destination, adapter);
        this.myMessengers.add(context);
        this.myBlockingReceivers.put(name, context);
    }

    <M, R extends SpecificRecordBase> void addSender(String name, Session session, Destination destination, Adapter<M, R> adapter) throws JMSException {
        SenderContext<M, R> context = new SenderContext<M, R>(name, session, destination, adapter);
        this.myMessengers.add(context);
        this.mySenders.put(name, context);
    }

    void start() throws Exception {
        for (Connection con : this.myConnections) {
            con.start();
        }
        for (MessengerContext context : this.myMessengers) {
            context.start();
        }
    }

    void stop() {
        for (MessengerContext context : this.myMessengers) {
            try {
                context.stop();
            }
            catch (JMSException ex) {
                theLogger.log(Level.WARNING, "Error closing " + context.name, ex);
            }
        }
        for (Connection con : this.myConnections) {
            try {
                con.stop();
            }
            catch (JMSException ex) {
                theLogger.log(Level.WARNING, "Error closing connection", ex);
            }
        }
    }

    <M> MessageSender<M> getSender(String name) {
        SenderContext c = this.mySenders.get(name);
        return c == null ? null : c.sender;
    }

    <M> MessageAsyncReceiver<M> getAsyncReceiver(String name) {
        AsyncReceiverContext c = this.myAsyncReceivers.get(name);
        return c == null ? null : c.receiver;
    }

    <M> MessageBlockingReceiver<M> getBlockingReceiver(String name) {
        BlockingReceiverContext c = this.myBlockingReceivers.get(name);
        return c == null ? null : c.receiver;
    }

    static abstract class RkServiceConnector {
        protected ConnectionContext myConnectionContext;
        protected boolean myConnectionsFlag = false;

        void setConnectionContext(ConnectionContext context) {
            if (this.myConnectionContext != null) {
                return;
            }
            this.myConnectionContext = context;
        }

        protected void addConnection(Session session) throws JMSException, URISyntaxException {
        }
    }

    private static final class ConnectionConfig {
        private String myUsername;
        private String myPassword;
        private String myClientName;
        private String myVirtualHost;
        private String myIpAddress;
        private String myPortNumber;

        static ConnectionConfig makeDefault(String ip) {
            return new ConnectionConfig("admin", "admin", "client1", "test", ip, "5672");
        }

        private ConnectionConfig(String username, String password, String clientId, String virtualHost, String ipAddress, String portNumber) {
            this.myUsername = username;
            this.myPassword = password;
            this.myClientName = clientId;
            this.myVirtualHost = virtualHost;
            this.myIpAddress = ipAddress;
            this.myPortNumber = portNumber;
        }

        String getUsername() {
            return this.myUsername;
        }

        String getPassword() {
            return this.myPassword;
        }

        String getClientName() {
            return this.myClientName;
        }

        String getVirtualHost() {
            return this.myVirtualHost;
        }

        String getIpAddress() {
            return this.myIpAddress;
        }

        String getPortNumber() {
            return this.myPortNumber;
        }
    }

    private static final class BlockingReceiverContext<M>
    extends MessengerContext {
        final DefaultMessageBlockingReceiver<M, BytesMessage> receiver;

        BlockingReceiverContext(String name, Session session, Destination destination, Adapter<BytesMessage, M> adapter) throws JMSException {
            super(name, session, destination);
            MessageConsumer consumer = session.createConsumer(destination);
            JMSBytesRecordBlockingReceiver recReceiver = new JMSBytesRecordBlockingReceiver(consumer);
            this.receiver = new DefaultMessageBlockingReceiver();
            this.receiver.setRecordReceiver((RecordBlockingReceiver)recReceiver);
            this.receiver.setAdapter(adapter);
        }

        @Override
        void start() throws Exception {
            this.receiver.start();
        }

        @Override
        void stop() {
            this.receiver.stop();
        }
    }

    private static final class AsyncReceiverContext<M, R extends SpecificRecordBase>
    extends MessengerContext {
        final JMSAvroMessageAsyncReceiver<M, R> receiver;

        AsyncReceiverContext(String name, Session session, Destination destination, Class<R> recordClass, Schema recordSchema, Adapter<R, M> adapter) throws JMSException {
            super(name, session, destination);
            this.receiver = new JMSAvroMessageAsyncReceiver(session, destination, recordClass, recordSchema);
            this.receiver.setAdapter(adapter);
        }

        @Override
        void start() throws Exception {
            this.receiver.start();
        }

        @Override
        void stop() {
            this.receiver.stop();
        }
    }

    private static final class SenderContext<M, R extends SpecificRecordBase>
    extends MessengerContext {
        final JMSAvroMessageSender<M, R> sender;

        SenderContext(String name, Session session, Destination destination, Adapter<M, R> adapter) throws JMSException {
            super(name, session, destination);
            this.sender = new JMSAvroMessageSender(session, destination);
            this.sender.setAdapter(adapter);
        }

        @Override
        void start() throws Exception {
            this.sender.start();
        }

        @Override
        void stop() {
            this.sender.stop();
        }
    }

    private static abstract class MessengerContext {
        final String name;
        final Session session;
        final Destination destination;

        MessengerContext(String name, Session session, Destination destination) {
            this.name = name;
            this.session = session;
            this.destination = destination;
        }

        abstract void start() throws Exception;

        abstract void stop() throws JMSException;
    }
}

