/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.client.basic;

import java.net.URISyntaxException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.jflux.api.core.util.EmptyAdapter;
import org.robokind.api.messaging.MessageAsyncReceiver;
import org.robokind.api.messaging.MessageSender;
import org.robokind.api.sensor.imu.RemoteCompassServiceClient;
import org.robokind.avrogen.sensor.FilteredVector3Record;
import org.robokind.client.basic.ConnectionContext;

final class RkCompassConnector
extends ConnectionContext.RkServiceConnector {
    static final String COMPASS_VALUE_RECEIVER = "compassValueReceiver";
    static final String COMPASS_CONFIG_SENDER = "compassConfigSender";
    static final String COMPASS_READ_PERIOD_SENDER = "compassReadPeriodSender";
    private static RkCompassConnector theRkCompassConnector;
    private String theCompassInputDest = "compassEvent";
    private String theCompassConfigDest = "compassConfig";
    private String theCompassReadDest = "compassRead";

    RkCompassConnector() {
    }

    static synchronized RkCompassConnector getConnector() {
        if (theRkCompassConnector == null) {
            theRkCompassConnector = new RkCompassConnector();
        }
        return theRkCompassConnector;
    }

    @Override
    protected synchronized void addConnection(Session session) throws JMSException, URISyntaxException {
        if (this.myConnectionContext == null || this.myConnectionsFlag) {
            return;
        }
        Destination compassValReceiver = ConnectionContext.getTopic(this.theCompassInputDest);
        this.myConnectionContext.addAsyncReceiver(COMPASS_VALUE_RECEIVER, session, compassValReceiver, FilteredVector3Record.class, FilteredVector3Record.SCHEMA$, new EmptyAdapter());
        Destination compassCfgSender = ConnectionContext.getTopic(this.theCompassConfigDest);
        this.myConnectionContext.addSender(COMPASS_CONFIG_SENDER, session, compassCfgSender, new EmptyAdapter());
        Destination compassPerSender = ConnectionContext.getTopic(this.theCompassReadDest);
        this.myConnectionContext.addSender(COMPASS_READ_PERIOD_SENDER, session, compassPerSender, new EmptyAdapter());
        this.myConnectionsFlag = true;
    }

    synchronized RemoteCompassServiceClient buildRemoteClient() {
        if (this.myConnectionContext == null || !this.myConnectionsFlag) {
            return null;
        }
        MessageAsyncReceiver compassValReceiver = this.myConnectionContext.getAsyncReceiver(COMPASS_VALUE_RECEIVER);
        MessageSender compassCfgSender = this.myConnectionContext.getSender(COMPASS_CONFIG_SENDER);
        MessageSender compassPerSender = this.myConnectionContext.getSender(COMPASS_READ_PERIOD_SENDER);
        RemoteCompassServiceClient client = new RemoteCompassServiceClient(compassCfgSender, compassPerSender, compassValReceiver);
        return client;
    }
}

