/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.client.basic;

import java.net.URISyntaxException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.jflux.api.core.util.EmptyAdapter;
import org.robokind.api.messaging.MessageAsyncReceiver;
import org.robokind.api.messaging.MessageSender;
import org.robokind.api.sensor.imu.RemoteGyroscopeServiceClient;
import org.robokind.avrogen.sensor.FilteredVector3Record;
import org.robokind.client.basic.ConnectionContext;

final class RkGyroscopeConnector
extends ConnectionContext.RkServiceConnector {
    static final String GYRO_VALUE_RECEIVER = "gyroValueReceiver";
    static final String GYRO_CONFIG_SENDER = "gyroConfigSender";
    static final String GYRO_READ_PERIOD_SENDER = "gyroReadPeriodSender";
    private static RkGyroscopeConnector theRkGyroscopeConnector;
    private String theGyroInputDest = "gyroEvent";
    private String theGyroConfigDest = "gyroConfig";
    private String theGyroReadDest = "gyroRead";

    RkGyroscopeConnector() {
    }

    static synchronized RkGyroscopeConnector getConnector() {
        if (theRkGyroscopeConnector == null) {
            theRkGyroscopeConnector = new RkGyroscopeConnector();
        }
        return theRkGyroscopeConnector;
    }

    @Override
    protected synchronized void addConnection(Session session) throws JMSException, URISyntaxException {
        if (this.myConnectionContext == null || this.myConnectionsFlag) {
            return;
        }
        Destination gyroValReceiver = ConnectionContext.getTopic(this.theGyroInputDest);
        this.myConnectionContext.addAsyncReceiver(GYRO_VALUE_RECEIVER, session, gyroValReceiver, FilteredVector3Record.class, FilteredVector3Record.SCHEMA$, new EmptyAdapter());
        Destination gyroCfgSender = ConnectionContext.getTopic(this.theGyroConfigDest);
        this.myConnectionContext.addSender(GYRO_CONFIG_SENDER, session, gyroCfgSender, new EmptyAdapter());
        Destination gyroPerSender = ConnectionContext.getTopic(this.theGyroReadDest);
        this.myConnectionContext.addSender(GYRO_READ_PERIOD_SENDER, session, gyroPerSender, new EmptyAdapter());
        this.myConnectionsFlag = true;
    }

    synchronized RemoteGyroscopeServiceClient buildRemoteClient() {
        if (this.myConnectionContext == null || !this.myConnectionsFlag) {
            return null;
        }
        MessageAsyncReceiver gyroValReceiver = this.myConnectionContext.getAsyncReceiver(GYRO_VALUE_RECEIVER);
        MessageSender gyroCfgSender = this.myConnectionContext.getSender(GYRO_CONFIG_SENDER);
        MessageSender gyroPerSender = this.myConnectionContext.getSender(GYRO_READ_PERIOD_SENDER);
        RemoteGyroscopeServiceClient client = new RemoteGyroscopeServiceClient(gyroCfgSender, gyroPerSender, gyroValReceiver);
        return client;
    }
}

