/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.client.basic;

import java.net.URISyntaxException;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.robokind.api.messaging.MessageBlockingReceiver;
import org.robokind.api.messaging.MessageSender;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.messaging.RemoteRobotClient;
import org.robokind.api.motion.messaging.RobotRequestFactory;
import org.robokind.api.motion.protocol.MotionFrameEvent;
import org.robokind.client.basic.ConnectionContext;
import org.robokind.impl.motion.messaging.PortableMotionFrameEvent;
import org.robokind.impl.motion.messaging.PortableRobotRequest;
import org.robokind.impl.motion.messaging.PortableRobotResponse;

final class RkRobotConnector
extends ConnectionContext.RkServiceConnector {
    private static final Logger theLogger = Logger.getLogger(RkRobotConnector.class.getName());
    private static final String theDefaultId = "Avatar_ZenoR50";
    private static final String RESPONSE_RECEIVER = "robotResponseReceiver";
    private static final String REQUEST_SENDER = "robotRequestSender";
    private static final String MOVE_SENDER = "robotMoveSender";
    private static RkRobotConnector theRkRobotConnector;
    private String myRobotIdStr;
    private Robot.Id myRobotId;
    private String myResponseDest;
    private String myRequestDest;
    private String myMoveDest;
    private RemoteRobotClient myRobotClient;

    static synchronized RkRobotConnector getConnector() {
        if (theRkRobotConnector == null) {
            theRkRobotConnector = new RkRobotConnector();
        }
        return theRkRobotConnector;
    }

    static synchronized void clearConnector() {
        theRkRobotConnector = null;
    }

    public RkRobotConnector() {
        this.setRobotId(theDefaultId);
    }

    void setRobotId(String robotId) {
        if (robotId == null) {
            throw new NullPointerException();
        }
        this.myRobotIdStr = robotId;
        this.myRobotId = new Robot.Id(this.myRobotIdStr);
        String cleanId = this.myRobotIdStr.replaceAll("[^a-zA-Z0-9]+", "");
        this.myResponseDest = "robot" + cleanId + "hostrobotResponse";
        this.myRequestDest = "robot" + cleanId + "hostrobotRequest";
        this.myMoveDest = "robot" + cleanId + "hostmotionFrame";
    }

    @Override
    protected synchronized void addConnection(Session session) throws JMSException, URISyntaxException {
        if (this.myConnectionContext == null || this.myConnectionsFlag) {
            return;
        }
        Destination resp = ConnectionContext.getTopic(this.myResponseDest);
        Destination req = ConnectionContext.getTopic(this.myRequestDest);
        Destination move = ConnectionContext.getTopic(this.myMoveDest);
        this.myConnectionContext.addBlockingPolyReceiver(RESPONSE_RECEIVER, session, resp, new PortableRobotResponse.RecordMessageAdapter());
        this.myConnectionContext.addSender(REQUEST_SENDER, session, req, new PortableRobotRequest.MessageRecordAdapter());
        this.myConnectionContext.addSender(MOVE_SENDER, session, move, new PortableMotionFrameEvent.MessageRecordAdapter());
        this.myConnectionsFlag = true;
    }

    synchronized RemoteRobotClient buildRemoteClient() {
        if (this.myConnectionContext == null || !this.myConnectionsFlag) {
            return null;
        }
        if (this.myRobotClient != null) {
            return this.myRobotClient;
        }
        MessageBlockingReceiver respReceiver = this.myConnectionContext.getBlockingReceiver(RESPONSE_RECEIVER);
        MessageSender reqSender = this.myConnectionContext.getSender(REQUEST_SENDER);
        MessageSender moveSender = this.myConnectionContext.getSender(MOVE_SENDER);
        this.myRobotClient = new RemoteRobotClient(this.myRobotId, "source", "dest", (RobotRequestFactory)new PortableRobotRequest.Factory(), (MotionFrameEvent.MotionFrameEventFactory)new PortableMotionFrameEvent.Factory());
        this.myRobotClient.setResponseReceiver(respReceiver);
        this.myRobotClient.setRequestSender(reqSender);
        this.myRobotClient.setMotionFrameSender(moveSender);
        return this.myRobotClient;
    }
}

