/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.client.basic;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.messaging.RemoteAnimationPlayerClient;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.motion.messaging.RemoteRobot;
import org.robokind.api.motion.messaging.RemoteRobotClient;
import org.robokind.api.sensor.gpio.GpioService;
import org.robokind.api.sensor.gpio.RemoteGpioServiceClient;
import org.robokind.api.sensor.imu.RemoteAccelerometerServiceClient;
import org.robokind.api.sensor.imu.RemoteCompassServiceClient;
import org.robokind.api.sensor.imu.RemoteGyroscopeServiceClient;
import org.robokind.api.speech.SpeechConfig;
import org.robokind.api.speech.messaging.RemoteSpeechServiceClient;
import org.robokind.api.vision.config.CameraServiceConfig;
import org.robokind.api.vision.config.FaceDetectServiceConfig;
import org.robokind.api.vision.messaging.RemoteImageRegionServiceClient;
import org.robokind.api.vision.messaging.RemoteImageServiceClient;
import org.robokind.avrogen.sensor.HeaderRecord;
import org.robokind.client.basic.ConnectionContext;
import org.robokind.client.basic.RkAccelerometerConnector;
import org.robokind.client.basic.RkAnimationConnector;
import org.robokind.client.basic.RkCameraConnector;
import org.robokind.client.basic.RkCompassConnector;
import org.robokind.client.basic.RkGyroscopeConnector;
import org.robokind.client.basic.RkImageRegionConnector;
import org.robokind.client.basic.RkRobotConnector;
import org.robokind.client.basic.RkSensorConnector;
import org.robokind.client.basic.RkSpeechConnector;
import org.robokind.client.basic.UserSettings;
import org.robokind.impl.animation.xml.AnimationXMLReader;
import org.robokind.impl.animation.xml.XPP3AnimationXMLWriter;

public final class Robokind {
    private static final Logger theLogger = Logger.getLogger(Robokind.class.getName());
    private static final Map<String, ConnectionContext> theConnectionMap = new HashMap<String, ConnectionContext>();
    private static final String theRobotContext = "robotContext";
    private static final String theSpeechContext = "speechContext";
    private static final String theAnimationContext = "animContext";
    private static final String theSensorContext = "sensorContext";
    private static final String theCameraContext = "cameraContext";
    private static final String theImageRegionContext = "imageRegionContext";

    public static RemoteRobot connectRobot() {
        try {
            ConnectionContext context = Robokind.getContext(theRobotContext);
            context.addConnection(RkRobotConnector.getConnector(), UserSettings.getRobotAddress());
            RemoteRobotClient robotClient = RkRobotConnector.getConnector().buildRemoteClient();
            context.start();
            return new RemoteRobot(robotClient);
        }
        catch (Exception ex) {
            theLogger.log(Level.SEVERE, "Unable to connect to Robokind Robot.", ex);
            return null;
        }
    }

    public static RemoteAnimationPlayerClient connectAnimationPlayer() {
        try {
            ConnectionContext context = Robokind.getContext(theAnimationContext);
            context.addConnection(RkAnimationConnector.getConnector(), UserSettings.getAnimationAddress());
            context.start();
            return RkAnimationConnector.getConnector().buildRemoteClient();
        }
        catch (Exception ex) {
            theLogger.log(Level.SEVERE, "Unable to connect to Robokind Sensors.", ex);
            return null;
        }
    }

    public static RemoteSpeechServiceClient connectSpeechService() {
        try {
            ConnectionContext context = Robokind.getContext(theSpeechContext);
            context.addConnection(RkSpeechConnector.getConnector(), UserSettings.getSpeechAddress());
            RemoteSpeechServiceClient<SpeechConfig> speechClient = RkSpeechConnector.getConnector().buildRemoteClient();
            context.start();
            speechClient.start();
            return speechClient;
        }
        catch (Exception ex) {
            theLogger.log(Level.SEVERE, "Unable to connect to Robokind Robot.", ex);
            return null;
        }
    }

    public static RemoteGpioServiceClient<HeaderRecord> connectSensors() {
        try {
            ConnectionContext context = Robokind.getContext(theSensorContext);
            context.addConnection(RkSensorConnector.getConnector(), UserSettings.getSensorAddress());
            RemoteGpioServiceClient gpioClient = RkSensorConnector.getConnector().buildRemoteClient();
            context.start();
            RkSensorConnector.initializeGpioClient((GpioService)gpioClient);
            return gpioClient;
        }
        catch (Exception ex) {
            theLogger.log(Level.SEVERE, "Unable to connect to Robokind Sensors.", ex);
            return null;
        }
    }

    public static RemoteAccelerometerServiceClient<HeaderRecord> connectAccelerometer() {
        try {
            ConnectionContext context = Robokind.getContext(theSensorContext);
            context.addConnection(RkAccelerometerConnector.getConnector(), UserSettings.getAccelerometerAddress());
            RemoteAccelerometerServiceClient accelClient = RkAccelerometerConnector.getConnector().buildRemoteClient();
            context.start();
            return accelClient;
        }
        catch (Exception ex) {
            theLogger.log(Level.SEVERE, "Unable to connect to Robokind Accelerometer.", ex);
            return null;
        }
    }

    public static RemoteGyroscopeServiceClient<HeaderRecord> connectGyroscope() {
        try {
            ConnectionContext context = Robokind.getContext(theSensorContext);
            context.addConnection(RkGyroscopeConnector.getConnector(), UserSettings.getGyroscopeAddress());
            RemoteGyroscopeServiceClient gyroClient = RkGyroscopeConnector.getConnector().buildRemoteClient();
            context.start();
            return gyroClient;
        }
        catch (Exception ex) {
            theLogger.log(Level.SEVERE, "Unable to connect to Robokind Gyroscope.", ex);
            return null;
        }
    }

    public static RemoteCompassServiceClient<HeaderRecord> connectCompass() {
        try {
            ConnectionContext context = Robokind.getContext(theSensorContext);
            context.addConnection(RkCompassConnector.getConnector(), UserSettings.getCompassAddress());
            RemoteCompassServiceClient compassClient = RkCompassConnector.getConnector().buildRemoteClient();
            context.start();
            return compassClient;
        }
        catch (Exception ex) {
            theLogger.log(Level.SEVERE, "Unable to connect to Robokind Compass.", ex);
            return null;
        }
    }

    public static RemoteImageServiceClient<CameraServiceConfig> connectCameraService() {
        try {
            ConnectionContext context = Robokind.getContext(theCameraContext);
            context.addConnection(RkCameraConnector.getConnector(), UserSettings.getCameraAddress());
            RemoteImageServiceClient<CameraServiceConfig> cameraClient = RkCameraConnector.getConnector().buildRemoteClient();
            context.start();
            cameraClient.start();
            return cameraClient;
        }
        catch (Exception ex) {
            theLogger.log(Level.SEVERE, "Unable to connect to Robokind Camera.", ex);
            return null;
        }
    }

    public static RemoteImageRegionServiceClient<FaceDetectServiceConfig> connectImageRegionService() {
        try {
            ConnectionContext context = Robokind.getContext(theImageRegionContext);
            context.addConnection(RkImageRegionConnector.getConnector(), UserSettings.getImageRegionAddress());
            RemoteImageRegionServiceClient<FaceDetectServiceConfig> imageRegionClient = RkImageRegionConnector.getConnector().buildRemoteClient();
            context.start();
            imageRegionClient.start();
            return imageRegionClient;
        }
        catch (Exception ex) {
            theLogger.log(Level.SEVERE, "Unable to connect to Robokind image region service.", ex);
            return null;
        }
    }

    private static synchronized ConnectionContext getContext(String key) {
        ConnectionContext cc = theConnectionMap.get(key);
        if (cc == null) {
            cc = new ConnectionContext();
            theConnectionMap.put(key, cc);
        }
        return cc;
    }

    public static Animation loadAnimation(String filepath) {
        try {
            return new AnimationXMLReader().readAnimation(filepath);
        }
        catch (Exception ex) {
            theLogger.log(Level.WARNING, "Unable to load animation.", ex);
            return null;
        }
    }

    public static boolean saveAnimation(String filepath, Animation anim) {
        try {
            new XPP3AnimationXMLWriter().writeAnimation(filepath, anim, null, null);
            return true;
        }
        catch (Exception ex) {
            theLogger.log(Level.WARNING, "Unable to load animation.", ex);
            return false;
        }
    }

    public static long currentTime() {
        return TimeUtils.now();
    }

    public static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException ex) {
            theLogger.log(Level.WARNING, "Sleep interrupted.", ex);
        }
    }

    public static void disconnect() {
        for (ConnectionContext cc : theConnectionMap.values()) {
            cc.stop();
        }
        theConnectionMap.clear();
        RkRobotConnector.clearConnector();
        RkAnimationConnector.theRkAnimationConnector = null;
        RkSpeechConnector.theRkSpeechConnector = null;
    }
}

