/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.client.basic;

import java.net.URISyntaxException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.jflux.api.core.util.EmptyAdapter;
import org.robokind.api.messaging.MessageAsyncReceiver;
import org.robokind.api.messaging.MessageSender;
import org.robokind.api.sensor.imu.RemoteAccelerometerServiceClient;
import org.robokind.client.basic.ConnectionContext;
import org.robokind.impl.sensor.FilteredVector3Record;

final class RkAccelerometerConnector
extends ConnectionContext.RkServiceConnector {
    static final String ACCEL_VALUE_RECEIVER = "accelValueReceiver";
    static final String ACCEL_CONFIG_SENDER = "accelConfigSender";
    static final String ACCEL_READ_PERIOD_SENDER = "accelReadPeriodSender";
    private static RkAccelerometerConnector theRkAccelerometerConnector;
    private String theAccelInputDest = "accelerometerEvent";
    private String theAccelConfigDest = "accelerometerConfig";
    private String theAccelReadDest = "accelerometerRead";

    RkAccelerometerConnector() {
    }

    static synchronized RkAccelerometerConnector getConnector() {
        if (theRkAccelerometerConnector == null) {
            theRkAccelerometerConnector = new RkAccelerometerConnector();
        }
        return theRkAccelerometerConnector;
    }

    @Override
    protected synchronized void addConnection(Session session) throws JMSException, URISyntaxException {
        if (this.myConnectionContext == null || this.myConnectionsFlag) {
            return;
        }
        Destination accelValReceiver = ConnectionContext.getTopic(this.theAccelInputDest);
        this.myConnectionContext.addAsyncReceiver(ACCEL_VALUE_RECEIVER, session, accelValReceiver, FilteredVector3Record.class, FilteredVector3Record.SCHEMA$, new EmptyAdapter());
        Destination accelCfgSender = ConnectionContext.getTopic(this.theAccelConfigDest);
        this.myConnectionContext.addSender(ACCEL_CONFIG_SENDER, session, accelCfgSender, new EmptyAdapter());
        Destination accelPerSender = ConnectionContext.getTopic(this.theAccelReadDest);
        this.myConnectionContext.addSender(ACCEL_READ_PERIOD_SENDER, session, accelPerSender, new EmptyAdapter());
        this.myConnectionsFlag = true;
    }

    synchronized RemoteAccelerometerServiceClient buildRemoteClient() {
        if (this.myConnectionContext == null || !this.myConnectionsFlag) {
            return null;
        }
        MessageAsyncReceiver accelValReceiver = this.myConnectionContext.getAsyncReceiver(ACCEL_VALUE_RECEIVER);
        MessageSender accelCfgSender = this.myConnectionContext.getSender(ACCEL_CONFIG_SENDER);
        MessageSender accelPerSender = this.myConnectionContext.getSender(ACCEL_READ_PERIOD_SENDER);
        RemoteAccelerometerServiceClient client = new RemoteAccelerometerServiceClient(accelCfgSender, accelPerSender, accelValReceiver);
        return client;
    }
}

