/*
 * Copyright 2013 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.robokind.client.basic;

import java.net.URISyntaxException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.robokind.api.animation.messaging.RemoteAnimationPlayerClient;
import org.robokind.api.animation.protocol.AnimationEvent;
import org.robokind.api.messaging.MessageSender;
import org.robokind.impl.animation.messaging.PortableAnimationEvent;
import org.robokind.client.basic.ConnectionContext.RkServiceConnector;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
final class RkAnimationConnector extends RkServiceConnector{
    final static String ANIMATION_SENDER = "animationSender";
    private String myAnimDest = "animationRequest";
    
    static RkAnimationConnector theRkAnimationConnector;
    
    static synchronized RkAnimationConnector getConnector(){
        if(theRkAnimationConnector == null){
            theRkAnimationConnector = new RkAnimationConnector();
        }
        return theRkAnimationConnector;
    }
    
    @Override
    protected synchronized void addConnection(Session session) 
            throws JMSException, URISyntaxException{
        if(myConnectionContext == null || myConnectionsFlag){
            return;
        }
        Destination anim = ConnectionContext.getTopic(myAnimDest);
        myConnectionContext.addSender(ANIMATION_SENDER, session, anim, 
                new PortableAnimationEvent.MessageRecordAdapter());
        myConnectionsFlag = true;
    }
    
    synchronized RemoteAnimationPlayerClient buildRemoteClient() {
        if(myConnectionContext == null || !myConnectionsFlag){
            return null;
        }
        
        MessageSender<AnimationEvent> animSender = myConnectionContext.getSender(ANIMATION_SENDER);
        
        RemoteAnimationPlayerClient client = new RemoteAnimationPlayerClient(
                null, "animationPlayer", "remoteAnimationPlayerId");
        client.setAnimationEventFactory(new PortableAnimationEvent.Factory());
        client.setAnimationEventSender(animSender);
        return client;
    }
}
