/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.client.basic;

import java.net.URISyntaxException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.robokind.api.animation.messaging.RemoteAnimationPlayerClient;
import org.robokind.api.animation.protocol.AnimationEvent;
import org.robokind.api.messaging.MessageSender;
import org.robokind.client.basic.ConnectionContext;
import org.robokind.impl.animation.messaging.PortableAnimationEvent;

final class RkAnimationConnector
extends ConnectionContext.RkServiceConnector {
    static final String ANIMATION_SENDER = "animationSender";
    private String myAnimDest = "animationRequest";
    static RkAnimationConnector theRkAnimationConnector;

    RkAnimationConnector() {
    }

    static synchronized RkAnimationConnector getConnector() {
        if (theRkAnimationConnector == null) {
            theRkAnimationConnector = new RkAnimationConnector();
        }
        return theRkAnimationConnector;
    }

    @Override
    protected synchronized void addConnection(Session session) throws JMSException, URISyntaxException {
        if (this.myConnectionContext == null || this.myConnectionsFlag) {
            return;
        }
        Destination anim = ConnectionContext.getTopic(this.myAnimDest);
        this.myConnectionContext.addSender(ANIMATION_SENDER, session, anim, new PortableAnimationEvent.MessageRecordAdapter());
        this.myConnectionsFlag = true;
    }

    synchronized RemoteAnimationPlayerClient buildRemoteClient() {
        if (this.myConnectionContext == null || !this.myConnectionsFlag) {
            return null;
        }
        MessageSender animSender = this.myConnectionContext.getSender(ANIMATION_SENDER);
        RemoteAnimationPlayerClient client = new RemoteAnimationPlayerClient(null, "animationPlayer", "remoteAnimationPlayerId");
        client.setAnimationEventFactory((AnimationEvent.AnimationEventFactory)new PortableAnimationEvent.Factory());
        client.setAnimationEventSender(animSender);
        return client;
    }
}

