/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.client.basic;

import java.net.URISyntaxException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.jflux.api.core.util.EmptyAdapter;
import org.robokind.api.messaging.MessageAsyncReceiver;
import org.robokind.api.messaging.MessageSender;
import org.robokind.api.messaging.services.ServiceCommandFactory;
import org.robokind.api.vision.config.FaceDetectServiceConfig;
import org.robokind.api.vision.messaging.RemoteImageRegionServiceClient;
import org.robokind.client.basic.ConnectionContext;
import org.robokind.client.basic.UserSettings;
import org.robokind.impl.messaging.ServiceErrorRecord;
import org.robokind.impl.messaging.services.PortableServiceCommand;
import org.robokind.impl.vision.ImageRegionListRecord;

final class RkImageRegionConnector
extends ConnectionContext.RkServiceConnector {
    static final String CMD_SENDER = "irCommandSender";
    static final String CONFIG_SENDER = "irConfigSender";
    static final String ERROR_RECEIVER = "irErrorReceiver";
    static final String EVENT_RECEIVER = "irEventReceiver";
    static RkImageRegionConnector theRkImageRegionConnector;
    private String myCommandDest = "visionproc0Command";
    private String myConfigDest = "visionproc0Command";
    private String myErrorDest = "visionproc0Error";
    private String myEventDest = "visionproc0Event";

    RkImageRegionConnector() {
    }

    static synchronized RkImageRegionConnector getConnector() {
        if (theRkImageRegionConnector == null) {
            theRkImageRegionConnector = new RkImageRegionConnector();
        }
        return theRkImageRegionConnector;
    }

    @Override
    protected synchronized void addConnection(Session session) throws JMSException, URISyntaxException {
        if (this.myConnectionContext == null || this.myConnectionsFlag) {
            return;
        }
        this.readCameraId();
        Destination cmdDest = ConnectionContext.getQueue(this.myCommandDest);
        Destination confDest = ConnectionContext.getQueue(this.myConfigDest);
        Destination errDest = ConnectionContext.getTopic(this.myErrorDest);
        Destination evtDest = ConnectionContext.getTopic(this.myEventDest);
        this.myConnectionContext.addSender(CMD_SENDER, session, cmdDest, new EmptyAdapter());
        this.myConnectionContext.addSender(CONFIG_SENDER, session, confDest, new EmptyAdapter());
        this.myConnectionContext.addAsyncReceiver(ERROR_RECEIVER, session, errDest, ServiceErrorRecord.class, ServiceErrorRecord.SCHEMA$, new EmptyAdapter());
        this.myConnectionContext.addAsyncReceiver(EVENT_RECEIVER, session, evtDest, ImageRegionListRecord.class, ImageRegionListRecord.SCHEMA$, new EmptyAdapter());
        this.myConnectionsFlag = true;
    }

    synchronized RemoteImageRegionServiceClient<FaceDetectServiceConfig> buildRemoteClient() {
        if (this.myConnectionContext == null || !this.myConnectionsFlag) {
            return null;
        }
        MessageSender cmdSender = this.myConnectionContext.getSender(CMD_SENDER);
        MessageSender confSender = this.myConnectionContext.getSender(CONFIG_SENDER);
        MessageAsyncReceiver errReceiver = this.myConnectionContext.getAsyncReceiver(ERROR_RECEIVER);
        MessageAsyncReceiver evtReceiver = this.myConnectionContext.getAsyncReceiver(EVENT_RECEIVER);
        RemoteImageRegionServiceClient client = new RemoteImageRegionServiceClient(FaceDetectServiceConfig.class, "imageRegionServiceId", "remoteImageRegionServiceId", cmdSender, confSender, errReceiver, (ServiceCommandFactory)new PortableServiceCommand.Factory(), evtReceiver);
        return client;
    }

    private synchronized void readCameraId() {
        String cameraId = UserSettings.getImageRegionId();
        if (cameraId.equals("0")) {
            this.myCommandDest = this.myCommandDest.replace("1", cameraId);
            this.myConfigDest = this.myConfigDest.replace("1", cameraId);
            this.myErrorDest = this.myErrorDest.replace("1", cameraId);
            this.myEventDest = this.myEventDest.replace("1", cameraId);
        } else if (cameraId.equals("1")) {
            this.myCommandDest = this.myCommandDest.replace("0", cameraId);
            this.myConfigDest = this.myConfigDest.replace("0", cameraId);
            this.myErrorDest = this.myErrorDest.replace("0", cameraId);
            this.myEventDest = this.myEventDest.replace("0", cameraId);
        }
    }
}

