/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.demo.robot.replication;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Source;
import org.jflux.api.core.event.Event;
import org.jflux.api.core.event.Header;
import org.jflux.api.core.event.MutableHeader;
import org.jflux.api.core.util.DefaultTimestampSource;
import org.jflux.avrogen.EventListRecord;
import org.jflux.avrogen.EventRecord;
import org.jflux.avrogen.HeaderRecord;

public class EventEncoder<T>
implements Adapter<Event<Header<String, Long>, T>, EventRecord> {
    private Adapter<Header<String, Long>, HeaderRecord> myHeaderAdapter = new MutableHeader.HeaderChanger(HeaderRecord.class, (Source)HeaderRecord.newBuilder());
    private Adapter<T, ByteBuffer> myDataEncoder;

    public EventEncoder(Adapter<T, ByteBuffer> dataEncoder) {
        this.myDataEncoder = dataEncoder;
    }

    public void setDataEncoder(Adapter<T, ByteBuffer> dataEncoder) {
        this.myDataEncoder = dataEncoder;
    }

    public EventRecord adapt(Event<Header<String, Long>, T> a) {
        if (this.myDataEncoder == null) {
            return null;
        }
        Header h = (Header)a.getHeader();
        Object t = a.getData();
        HeaderRecord hRec = (HeaderRecord)this.myHeaderAdapter.adapt((Object)h);
        ByteBuffer b = (ByteBuffer)this.myDataEncoder.adapt(t);
        EventRecord e = new EventRecord();
        e.setHeader(hRec);
        e.setData(b);
        return e;
    }

    public static class HeaderRecordSource
    implements Source<HeaderRecord> {
        private Source<HeaderRecord> myHeaderSource;
        private Source<Long> myTimestampSource;

        public HeaderRecordSource(String eventType, String sourceReference, Map<String, String> properties) {
            HeaderRecord template = new HeaderRecord();
            template.setEventType(eventType);
            template.setSourceReference(sourceReference);
            template.setHeaderProperties(properties);
            this.myHeaderSource = HeaderRecord.newBuilder((HeaderRecord)template);
            this.myTimestampSource = new DefaultTimestampSource();
        }

        public HeaderRecord getValue() {
            HeaderRecord h = (HeaderRecord)this.myHeaderSource.getValue();
            h.setTimestamp((Long)this.myTimestampSource.getValue());
            return h;
        }
    }

    public static class EventListEncoder
    implements Adapter<List<EventRecord>, EventListRecord> {
        private static final Schema theEventArraySchema = Schema.createArray((Schema)HeaderRecord.SCHEMA$);
        private Source<HeaderRecord> myHeaderSource;

        public EventListEncoder(Source<HeaderRecord> headerSource) {
            this.myHeaderSource = headerSource;
        }

        public EventListRecord adapt(List<EventRecord> a) {
            if (a == null || a.isEmpty()) {
                return null;
            }
            EventListRecord l = new EventListRecord();
            l.setHeader((HeaderRecord)this.myHeaderSource.getValue());
            l.setData((List)new GenericData.Array(theEventArraySchema, a));
            return l;
        }
    }
}

