/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.demo.robot.replication.chain;

import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Notifier;
import org.jflux.api.core.node.ConsumerNode;
import org.jflux.api.core.node.Node;
import org.jflux.api.core.node.ProcessorNode;
import org.jflux.api.core.node.ProducerNode;

public class ChainLinkUtils {
    public static <T> NodeChainLink<T, ProducerNode<T>, ProcessorNode<T, ?>> producerProcessorLink(ProducerNode<T> producer, ProcessorNode<T, ?> processor) {
        return new NodeChainLink(producer, processor, new ProducerNotifierAdapter(), new ProcessorListenerAdapter());
    }

    public static <T> NodeChainLink<T, ProducerNode<T>, ConsumerNode<T>> producerConsumerLink(ProducerNode<T> producer, ConsumerNode<T> consumer) {
        return new NodeChainLink(producer, consumer, new ProducerNotifierAdapter(), new ConsumerListenerAdapter());
    }

    public static <T> NodeChainLink<T, ProcessorNode<?, T>, ConsumerNode<T>> processorConsumerLink(ProcessorNode<?, T> processor, ConsumerNode<T> consumer) {
        return new NodeChainLink(processor, consumer, new ProcessorNotifierAdapter(), new ConsumerListenerAdapter());
    }

    public static <T> NodeChainLink<T, ProcessorNode<?, T>, ProcessorNode<T, ?>> processorLink(ProcessorNode<?, T> procA, ProcessorNode<T, ?> procB) {
        return new NodeChainLink(procA, procB, new ProcessorNotifierAdapter(), new ProcessorListenerAdapter());
    }

    public static class ChainLink<T> {
        private Notifier<T> myNotifier;
        private Listener<T> myListener;

        public ChainLink(Notifier<T> notifier, Listener<T> listener) {
            this.myNotifier = notifier;
            this.myListener = listener;
            this.addListener();
        }

        public void setNotifier(Notifier<T> notifier) {
            this.unlink();
            this.myNotifier = notifier;
            this.link();
        }

        public void setListener(Listener<T> listener) {
            this.unlink();
            this.myListener = listener;
            this.link();
        }

        protected void link() {
            this.addListener();
        }

        private void addListener() {
            if (this.myListener == null || this.myNotifier == null) {
                return;
            }
            this.myNotifier.addListener(this.myListener);
        }

        protected void unlink() {
            this.removeListener();
        }

        private void removeListener() {
            if (this.myListener == null || this.myNotifier == null) {
                return;
            }
            this.myNotifier.removeListener(this.myListener);
        }
    }

    public static class ConsumerListenerAdapter<T>
    implements Adapter<ConsumerNode<T>, Listener<T>> {
        public Listener<T> adapt(ConsumerNode<T> a) {
            return a == null ? null : a.getListener();
        }
    }

    public static class ProcessorListenerAdapter<T>
    implements Adapter<ProcessorNode<T, ?>, Listener<T>> {
        public Listener<T> adapt(ProcessorNode<T, ?> a) {
            return a == null ? null : a.getListener();
        }
    }

    public static class ProcessorNotifierAdapter<T>
    implements Adapter<ProcessorNode<?, T>, Notifier<T>> {
        public Notifier<T> adapt(ProcessorNode<?, T> a) {
            return a == null ? null : a.getNotifier();
        }
    }

    public static class ProducerNotifierAdapter<T>
    implements Adapter<ProducerNode<T>, Notifier<T>> {
        public Notifier<T> adapt(ProducerNode<T> a) {
            return a == null ? null : a.getNotifier();
        }
    }

    public static class NodeChainLink<T, A extends Node, B extends Node>
    extends ChainLink<T> {
        private A myNotifyingNode;
        private B myListeningNode;
        private Adapter<A, Notifier<T>> myAdapterA;
        private Adapter<B, Listener<T>> myAdapterB;

        NodeChainLink(A notifying, B listening, Adapter<A, Notifier<T>> adapterA, Adapter<B, Listener<T>> adapterB) {
            super((Notifier)adapterA.adapt(notifying), (Listener)adapterB.adapt(listening));
            this.myNotifyingNode = notifying;
            this.myListeningNode = listening;
            this.myAdapterA = adapterA;
            this.myAdapterB = adapterB;
        }

        public void setNotifyingNode(A notifying) {
            this.myNotifyingNode = notifying;
            this.setNotifier((Notifier)this.myAdapterA.adapt(this.myNotifyingNode));
        }

        public void setListeningNode(B listening) {
            this.myListeningNode = listening;
            this.setListener((Listener)this.myAdapterB.adapt(this.myListeningNode));
        }
    }
}

