/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.demo.robot.replication.lifecycle;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Source;
import org.jflux.api.core.chain.AdapterChain;
import org.jflux.api.core.chain.ListenerChain;
import org.jflux.api.core.chain.SourceChain;
import org.jflux.api.core.config.Configuration;
import org.jflux.api.core.event.BasicEvent;
import org.jflux.api.core.event.Event;
import org.jflux.api.core.event.Header;
import org.jflux.api.core.node.ConsumerNode;
import org.jflux.api.core.node.DefaultConsumerNode;
import org.jflux.api.core.util.BatchAdapter;
import org.jflux.api.core.util.EmptyListener;
import org.jflux.api.core.util.ListAdapter;
import org.jflux.api.core.util.MapAdapter;
import org.jflux.api.core.util.SourceAdapter;
import org.jflux.api.data.buffer.Buffer;
import org.jflux.api.data.buffer.CircularBuffer;
import org.jflux.api.encode.BytesUtils;
import org.jflux.api.encode.EncodeRequest;
import org.jflux.avrogen.EventRecord;
import org.jflux.impl.encode.avro.AvroEncoder;
import org.jflux.impl.messaging.JMSAvroUtils;
import org.robokind.api.common.lifecycle.config.RKDependencyConfigUtils;
import org.robokind.api.common.lifecycle.config.RKLifecycleConfigUtils;
import org.robokind.api.common.lifecycle.config.RKManagedGroupConfigUtils;
import org.robokind.demo.robot.replication.EventEncoder;

public class EventBufferUtils {
    private static final String theEncodeConfig = "encodeConfig";
    private static final String theDataEventFactory = "dataEventFactory";
    private static final String theEventEncoder = "eventEncoder";
    private static final String theDataEventFactoryIdKey = "encodeConfig";
    private static final String theEventEncoderIdKey = "encodeConfig";
    public static final String PROP_EVENT_BUFFER_NODE_ID = "eventBufferNode";
    public static final String PROP_EVENT_TYPE = "eventType";

    public static List<Configuration<String>> getLifecycleConfigs(String encodeConfigIdKey, String encodeConfigId, String eventFactoryId, String eventKey, String sourceRef, String eventEncoderId, String eventBufferId, Properties bufferProps, int capacity) {
        return Arrays.asList(EventBufferUtils.buildDataEventFactoryLifecycleConfig(encodeConfigIdKey, encodeConfigId, eventFactoryId, eventKey, sourceRef), EventBufferUtils.buildEventEncoderLifecycleConfig(encodeConfigIdKey, encodeConfigId, eventEncoderId), EventBufferUtils.buildEventBufferLifecycleConfig(eventBufferId, bufferProps, capacity, eventFactoryId, eventEncoderId));
    }

    public static Configuration<String> buildDataEventFactoryLifecycleConfig(String encodeConfigIdKey, String encodeConfigId, String eventFactoryId, final String eventKey, final String sourceRef) {
        Configuration depConf = RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)"encodeConfig", Configuration.class, (String)encodeConfigIdKey, (String)encodeConfigId, null, null);
        Properties props = new Properties();
        props.put(PROP_EVENT_TYPE, eventKey);
        return RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((Configuration)RKLifecycleConfigUtils.buildGenericLifecycleConfig((String[])new String[]{Adapter.class.getName(), BasicEvent.BasicEventFactory.class.getName()}, (String)"encodeConfig", (String)eventFactoryId, (Properties)props, Arrays.asList(depConf), (Adapter)new MapAdapter.MapValueAdapter((Object)"encodeConfig", (Adapter)new Adapter<Configuration, BasicEvent.BasicEventFactory>(){

            public BasicEvent.BasicEventFactory adapt(Configuration a) {
                return new BasicEvent.BasicEventFactory((Source)EventBufferUtils.buildHeaderSource(eventKey, sourceRef, (Configuration<String>)a));
            }
        })));
    }

    private static EventEncoder.HeaderRecordSource buildHeaderSource(String eventKey, String sourceRef, Configuration<String> conf) {
        Class msgClass = (Class)conf.getPropertyValue((Object)"serializationMessageClass");
        HashMap<String, String> props = new HashMap<String, String>(1);
        props.put("serializationMessageClass", msgClass.toString());
        return new EventEncoder.HeaderRecordSource(eventKey, sourceRef, props);
    }

    public static <T, R extends IndexedRecord> Configuration<String> buildEventEncoderLifecycleConfig(String encodeConfigIdKey, String encodeConfigId, String eventEncoderId) {
        Configuration depConf = RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)"encodeConfig", Configuration.class, (String)encodeConfigIdKey, (String)encodeConfigId, null, null);
        return RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((Configuration)RKLifecycleConfigUtils.buildGenericLifecycleConfig((String[])new String[]{Adapter.class.getName(), EventEncoder.class.getName()}, (String)"encodeConfig", (String)eventEncoderId, null, Arrays.asList(depConf), (Adapter)new MapAdapter.MapValueAdapter((Object)"encodeConfig", (Adapter)new Adapter<Configuration, EventEncoder>(){

            public EventEncoder adapt(Configuration a) {
                return new EventEncoder(EventBufferUtils.encoder((Configuration<String>)a));
            }
        })));
    }

    private static <T, R extends IndexedRecord> Adapter<T, ByteBuffer> encoder(Configuration<String> config) {
        Adapter msgAdapter = (Adapter)config.getPropertyValue((Object)"serializationSenderEncoderAdapter");
        Class clazz = (Class)config.getPropertyValue((Object)"serializationRecordClass");
        Schema schema = (Schema)config.getPropertyValue((Object)"avroRecordSchema");
        return AdapterChain.builder((Adapter)msgAdapter).attach(EncodeRequest.factory((Class)clazz, (Source)new JMSAvroUtils.ByteOutputStreamFactory())).attach((Adapter)new AvroEncoder(clazz, schema, false)).attach(BytesUtils.outputStreamToBuffer()).done();
    }

    public static <T> Configuration<String> buildEventBufferLifecycleConfig(String eventBufferId, Properties bufferProps, final int capacity, String eventFactId, String eventEncoderId) {
        List<Configuration> deps = Arrays.asList(RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)theDataEventFactory, BasicEvent.BasicEventFactory.class, (String)"encodeConfig", (String)eventFactId, null, null), RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)theEventEncoder, EventEncoder.class, (String)"encodeConfig", (String)eventEncoderId, null, null));
        return RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((Configuration)RKLifecycleConfigUtils.buildGenericLifecycleConfig((String[])new String[]{EventBuffer.class.getName(), ConsumerNode.class.getName()}, (String)PROP_EVENT_BUFFER_NODE_ID, (String)eventBufferId, null, deps, (Adapter)new Adapter<Map<String, Object>, EventBuffer>(){

            public EventBuffer adapt(Map<String, Object> a) {
                BasicEvent.BasicEventFactory eventFactory = (BasicEvent.BasicEventFactory)a.get(EventBufferUtils.theDataEventFactory);
                EventEncoder eventEncoder = (EventEncoder)a.get(EventBufferUtils.theEventEncoder);
                CircularBuffer b = new CircularBuffer(capacity);
                EventBuffer eb = new EventBuffer(eventFactory, b, eventEncoder);
                eb.start();
                return eb;
            }
        }, (Listener)new Listener<EventBuffer>(){

            public void handleEvent(EventBuffer input) {
                input.stop();
            }
        }));
    }

    public static List<Configuration<String>> getAlternateLifecycleConfigs(String encodeConfigIdKey, String encodeConfigId, String eventFactoryId, String eventKey, String sourceRef, String eventEncoderId, String eventBufferId, Source<?> valueSource) {
        return Arrays.asList(EventBufferUtils.buildDataEventFactoryLifecycleConfig(encodeConfigIdKey, encodeConfigId, eventFactoryId, eventKey, sourceRef), EventBufferUtils.buildEventEncoderLifecycleConfig(encodeConfigIdKey, encodeConfigId, eventEncoderId), EventBufferUtils.buildAlternateEventBufferLifecycleConfig(eventBufferId, eventFactoryId, eventEncoderId, valueSource));
    }

    public static <T> Configuration<String> buildAlternateEventBufferLifecycleConfig(String eventBufferId, String eventFactId, String eventEncoderId, final Source<T> valueSource) {
        List<Configuration> deps = Arrays.asList(RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)theDataEventFactory, BasicEvent.BasicEventFactory.class, (String)"encodeConfig", (String)eventFactId, null, null), RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)theEventEncoder, EventEncoder.class, (String)"encodeConfig", (String)eventEncoderId, null, null));
        return RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((Configuration)RKLifecycleConfigUtils.buildGenericLifecycleConfig((String[])new String[]{EventBuffer.class.getName(), ConsumerNode.class.getName()}, (String)PROP_EVENT_BUFFER_NODE_ID, (String)eventBufferId, null, deps, (Adapter)new Adapter<Map<String, Object>, EventBuffer>(){

            public EventBuffer adapt(Map<String, Object> a) {
                BasicEvent.BasicEventFactory eventFactory = (BasicEvent.BasicEventFactory)a.get(EventBufferUtils.theDataEventFactory);
                EventEncoder eventEncoder = (EventEncoder)a.get(EventBufferUtils.theEventEncoder);
                SourceBuffer b = new SourceBuffer(valueSource, eventFactory);
                EventBuffer eb = new EventBuffer(eventFactory, b, eventEncoder);
                eb.start();
                return eb;
            }
        }, (Listener)new Listener<EventBuffer>(){

            public void handleEvent(EventBuffer input) {
                input.stop();
            }
        }));
    }

    static class SourceBuffer<V>
    implements Buffer<Integer, Event<Header<String, Long>, V>> {
        private Source<V> myValueSource;
        private Adapter<V, Event<Header<String, Long>, V>> myEventAdapter;
        private Source<Event<Header<String, Long>, V>> myEventSource;
        private Source<? extends Iterable<Event<Header<String, Long>, V>>> myValuesSource;
        private Adapter<Integer, Event<Header<String, Long>, V>> myIndexAdapter;
        private Listener<Event<Header<String, Long>, V>> myValueListener;

        public SourceBuffer(Source<V> valueSource, Adapter<V, Event<Header<String, Long>, V>> eventAdapter) {
            this.myValueSource = valueSource;
            this.myEventAdapter = eventAdapter;
            this.myEventSource = new SourceChain(this.myValueSource, this.myEventAdapter);
            this.myValuesSource = new SourceChain(this.myEventSource, (Adapter)new ListAdapter(1));
            this.myIndexAdapter = new SourceAdapter(this.myEventSource);
            this.myValueListener = new EmptyListener();
        }

        public Source<Event<Header<String, Long>, V>> getHead() {
            return this.myEventSource;
        }

        public Source<Event<Header<String, Long>, V>> getTail() {
            return this.myEventSource;
        }

        public Adapter<Integer, Event<Header<String, Long>, V>> getIndex() {
            return this.myIndexAdapter;
        }

        public Listener<Event<Header<String, Long>, V>> addValue() {
            return this.myValueListener;
        }

        public Source<? extends Iterable<Event<Header<String, Long>, V>>> getValues() {
            return this.myValuesSource;
        }
    }

    public static class EventBuffer<T>
    extends DefaultConsumerNode<T> {
        private Buffer<Integer, Event<Header<String, Long>, T>> myBuffer;
        private Adapter<Event<Header<String, Long>, T>, EventRecord> myEventAdapter;
        private Source<List<EventRecord>> myRecordSource;

        public EventBuffer(Adapter<T, Event<Header<String, Long>, T>> eventFactory, Buffer<Integer, Event<Header<String, Long>, T>> buffer, Adapter<Event<Header<String, Long>, T>, EventRecord> eventAdapter) {
            super((Listener)new ListenerChain(eventFactory, buffer.addValue()));
            if (eventFactory == null || buffer == null || eventAdapter == null) {
                throw new NullPointerException();
            }
            this.myBuffer = buffer;
            this.myEventAdapter = eventAdapter;
            this.myRecordSource = new SourceChain(this.myBuffer.getValues(), (Adapter)new BatchAdapter(this.myEventAdapter));
        }

        public Source<List<EventRecord>> getRecordValues() {
            return this.myRecordSource;
        }
    }
}

