/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.demo.robot.replication.lifecycle;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.Session;
import org.apache.avro.specific.SpecificRecordBase;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.jflux.api.core.chain.AdapterChain;
import org.jflux.api.core.config.Configuration;
import org.jflux.api.core.node.ConsumerNode;
import org.jflux.api.core.node.ProcessorNode;
import org.jflux.api.core.node.ProducerNode;
import org.jflux.api.core.node.chain.NodeChainBuilder;
import org.jflux.api.core.node.chain.ProcessorChain;
import org.jflux.api.core.util.IteratorNode;
import org.jflux.api.encode.BytesUtils;
import org.jflux.avrogen.EventListRecord;
import org.jflux.avrogen.EventRecord;
import org.jflux.impl.encode.avro.AvroDecoder;
import org.jflux.impl.transport.jms.JMSMessageReceiver;
import org.jflux.impl.transport.jms.MessageUnpacker;
import org.robokind.api.common.lifecycle.config.GenericLifecycle;
import org.robokind.api.common.lifecycle.config.RKDependencyConfigUtils;
import org.robokind.api.common.lifecycle.config.RKLifecycleConfigUtils;
import org.robokind.api.common.lifecycle.config.RKManagedGroupConfigUtils;
import org.robokind.demo.robot.replication.EventDecoder;
import org.robokind.demo.robot.replication.RoutingDecoderNode;
import org.robokind.demo.robot.replication.chain.NodeLinkLifecycleUtils;

public class ReplicationReceiverLifecycleUtils {
    private static final String theDestination = "destination";
    private static final String theSession = "session";
    private static final String theRouter = "router";
    private static final String theEncodeConfig = "encodeConfig";
    private static final String theConsumer = "consumer";

    public static List<Configuration<String>> getLifecycleConfigs(String routerNodeIdKey, String routerNodeId, String eventListDecoderIdKey, String eventListDecoderId, String receiverIdKey, String receiverId, String destinationIdKey, String destinationId, String sessionIdKey, String sessionId, String receiverListDecoderLinkId, String listDecoderRouterLinkId) {
        return Arrays.asList(ReplicationReceiverLifecycleUtils.buildEventListDecoderNodeLifecycleConfig(eventListDecoderIdKey, eventListDecoderId), ReplicationReceiverLifecycleUtils.buildRoutingDecoderLifecycleConfig(routerNodeIdKey, routerNodeId), ReplicationReceiverLifecycleUtils.buildReceiverLifecycleConfig(receiverIdKey, receiverId, destinationIdKey, destinationId, sessionIdKey, sessionId), ReplicationReceiverLifecycleUtils.buildReceiverListDecoderLinkLifecycleConfigs(receiverListDecoderLinkId, receiverIdKey, receiverId, eventListDecoderIdKey, eventListDecoderId), ReplicationReceiverLifecycleUtils.buildListDecoderRouterLinkLifecycleConfigs(listDecoderRouterLinkId, eventListDecoderIdKey, eventListDecoderId, routerNodeIdKey, routerNodeId));
    }

    public static Configuration<String> buildReceiverListDecoderLinkLifecycleConfigs(String receiverListDecoderLinkId, String receiverIdKey, String receiverId, String listDecoderIdKey, String listDecoderId) {
        return NodeLinkLifecycleUtils.producerProcessorLinkLifecycleConfig(receiverListDecoderLinkId, null, receiverIdKey, receiverId, null, listDecoderIdKey, listDecoderId, null);
    }

    public static Configuration<String> buildListDecoderRouterLinkLifecycleConfigs(String listDecoderRouterLinkId, String listDecoderIdKey, String listDecoderId, String routerIdKey, String routerId) {
        return NodeLinkLifecycleUtils.processorConsumerLinkLifecycleConfig(listDecoderRouterLinkId, null, listDecoderIdKey, listDecoderId, null, routerIdKey, routerId, null);
    }

    public static Configuration<String> buildEventListDecoderNodeLifecycleConfig(String eventListDecoderIdKey, String eventListDecoderId) {
        return RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((Configuration)RKLifecycleConfigUtils.buildGenericLifecycleConfig((String[])new String[]{ProcessorNode.class.getName()}, (String)eventListDecoderIdKey, (String)eventListDecoderId, null, (Iterable)Collections.EMPTY_LIST, (Adapter)new Adapter<Map<String, Object>, ProcessorNode>(){

            public ProcessorNode<BytesMessage, EventRecord> adapt(Map<String, Object> a) {
                Adapter adapter = AdapterChain.builder((Adapter)new MessageUnpacker()).attach((Adapter)AvroDecoder.buildSpecificBinaryDecoder(EventListRecord.class)).attach((Adapter)new EventDecoder.EventListDecoder()).done();
                ProcessorChain n = NodeChainBuilder.build((Adapter)adapter).attach((ProcessorNode)new IteratorNode()).getProcessorChain();
                n.start();
                return n;
            }
        }, (Listener)new Listener<ProcessorNode>(){

            public void handleEvent(ProcessorNode input) {
                input.stop();
            }
        }));
    }

    public static Configuration<String> buildReceiverLifecycleConfig(String receiverIdKey, String receiverId, String destinationIdKey, String destinationId, String sessionIdKey, String sessionId) {
        List<Configuration> deps = Arrays.asList(RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)theDestination, Destination.class, (String)destinationIdKey, (String)destinationId, null, (Listener)new Listener<GenericLifecycle.DependencyChange<JMSMessageReceiver, Destination>>(){

            public void handleEvent(GenericLifecycle.DependencyChange<JMSMessageReceiver, Destination> input) {
                if (input.getService() != null) {
                    ((JMSMessageReceiver)input.getService()).setDestination((Destination)input.getDependency());
                }
            }
        }), RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)theSession, Session.class, (String)sessionIdKey, (String)sessionId, null, (Listener)new Listener<GenericLifecycle.DependencyChange<JMSMessageReceiver, Session>>(){

            public void handleEvent(GenericLifecycle.DependencyChange<JMSMessageReceiver, Session> input) {
                if (input.getService() != null) {
                    ((JMSMessageReceiver)input.getService()).setSession((Session)input.getDependency());
                }
            }
        }));
        return RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((Configuration)RKLifecycleConfigUtils.buildGenericLifecycleConfig((String[])new String[]{ProducerNode.class.getName(), JMSMessageReceiver.class.getName()}, (String)receiverIdKey, (String)receiverId, null, deps, (Adapter)new Adapter<Map<String, Object>, JMSMessageReceiver>(){

            public JMSMessageReceiver adapt(Map<String, Object> a) {
                Destination d = (Destination)a.get(ReplicationReceiverLifecycleUtils.theDestination);
                Session s = (Session)a.get(ReplicationReceiverLifecycleUtils.theSession);
                JMSMessageReceiver r = new JMSMessageReceiver(s, d);
                r.start();
                return r;
            }
        }, (Listener)new Listener<JMSMessageReceiver>(){

            public void handleEvent(JMSMessageReceiver input) {
                input.stop();
            }
        }));
    }

    public static Configuration<String> buildRoutingDecoderLifecycleConfig(String nodeIdKey, String nodeId) {
        return RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((Configuration)RKLifecycleConfigUtils.buildGenericLifecycleConfig((String[])new String[]{ConsumerNode.class.getName(), RoutingDecoderNode.class.getName()}, (String)nodeIdKey, (String)nodeId, null, (Iterable)Collections.EMPTY_LIST, (Adapter)new Adapter<Map<String, Object>, RoutingDecoderNode>(){

            public RoutingDecoderNode adapt(Map<String, Object> a) {
                RoutingDecoderNode r = RoutingDecoderNode.makeDefault();
                r.start();
                return r;
            }
        }));
    }

    public static <T, R extends SpecificRecordBase> Configuration<String> buildDecoderRouteLinkLifecycleConfig(String linkIdKey, String linkId, String routerIdKey, String routerId, String encodeConfigIdKey, String encodeConfigId) {
        List<Configuration> deps = Arrays.asList(RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)theRouter, RoutingDecoderNode.class, (String)routerIdKey, (String)routerId, null, (Listener)new Listener<GenericLifecycle.DependencyChange<RoutingDecoderNode.DecoderLink, RoutingDecoderNode>>(){

            public void handleEvent(GenericLifecycle.DependencyChange<RoutingDecoderNode.DecoderLink, RoutingDecoderNode> input) {
                if (input.getService() != null) {
                    ((RoutingDecoderNode.DecoderLink)input.getService()).setRoutingDecoder((RoutingDecoderNode)((Object)input.getDependency()));
                }
            }
        }), RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)theEncodeConfig, Configuration.class, (String)encodeConfigIdKey, (String)encodeConfigId, null, (Listener)new Listener<GenericLifecycle.DependencyChange<RoutingDecoderNode.DecoderLink, Configuration>>(){

            public void handleEvent(GenericLifecycle.DependencyChange<RoutingDecoderNode.DecoderLink, Configuration> input) {
                if (input.getService() == null) {
                    return;
                }
                Configuration c = (Configuration)input.getDependency();
                if (c == null) {
                    ((RoutingDecoderNode.DecoderLink)input.getService()).setDecoder(null, null);
                    return;
                }
                Class clazz = (Class)c.getPropertyValue((Object)"serializationMessageClass");
                Adapter decoder = (Adapter)c.getPropertyValue((Object)"serializationReceiverDecoderAdapter");
                ((RoutingDecoderNode.DecoderLink)input.getService()).setDecoder(clazz.toString(), decoder);
            }
        }));
        return RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((Configuration)RKLifecycleConfigUtils.buildGenericLifecycleConfig((String[])new String[]{RoutingDecoderNode.DecoderLink.class.getName()}, (String)linkIdKey, (String)linkId, null, deps, (Adapter)new Adapter<Map<String, Object>, RoutingDecoderNode.DecoderLink>(){

            public RoutingDecoderNode.DecoderLink adapt(Map<String, Object> a) {
                RoutingDecoderNode r = (RoutingDecoderNode)((Object)a.get(ReplicationReceiverLifecycleUtils.theRouter));
                Configuration c = (Configuration)a.get(ReplicationReceiverLifecycleUtils.theEncodeConfig);
                Class clazz = (Class)c.getPropertyValue((Object)"serializationMessageClass");
                Class recClazz = (Class)c.getPropertyValue((Object)"serializationRecordClass");
                Adapter decoder = (Adapter)c.getPropertyValue((Object)"serializationReceiverDecoderAdapter");
                return new RoutingDecoderNode.DecoderLink(r, clazz.toString(), AdapterChain.builder((Adapter)new BytesUtils.BufferToInputStream()).attach((Adapter)AvroDecoder.buildByteStreamDecoder((Class)recClazz)).attach(decoder).done());
            }
        }, (Listener)new Listener<RoutingDecoderNode.DecoderLink>(){

            public void handleEvent(RoutingDecoderNode.DecoderLink input) {
                input.unlink();
            }
        }));
    }

    public static <T> Configuration<String> buildEventRouteLinkLifecycleConfig(String linkIdKey, String linkId, String routerIdKey, String routerId, String consumerIdKey, String consumerId, final String routeKey) {
        List<Configuration> deps = Arrays.asList(RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)theRouter, RoutingDecoderNode.class, (String)routerIdKey, (String)routerId, null, (Listener)new Listener<GenericLifecycle.DependencyChange<RoutingDecoderNode.EventRouteLink, RoutingDecoderNode>>(){

            public void handleEvent(GenericLifecycle.DependencyChange<RoutingDecoderNode.EventRouteLink, RoutingDecoderNode> input) {
                if (input.getService() != null) {
                    ((RoutingDecoderNode.EventRouteLink)input.getService()).setRoutingDecoder((RoutingDecoderNode)((Object)input.getDependency()));
                }
            }
        }), RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)theConsumer, ConsumerNode.class, (String)consumerIdKey, (String)consumerId, null, (Listener)new Listener<GenericLifecycle.DependencyChange<RoutingDecoderNode.EventRouteLink, ConsumerNode>>(){

            public void handleEvent(GenericLifecycle.DependencyChange<RoutingDecoderNode.EventRouteLink, ConsumerNode> input) {
                if (input.getService() != null) {
                    ((RoutingDecoderNode.EventRouteLink)input.getService()).setRoute(routeKey, input.getDependency() == null ? null : ((ConsumerNode)input.getDependency()).getListener());
                }
            }
        }));
        return RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((Configuration)RKLifecycleConfigUtils.buildGenericLifecycleConfig((String[])new String[]{RoutingDecoderNode.EventRouteLink.class.getName()}, (String)linkIdKey, (String)linkId, null, deps, (Adapter)new Adapter<Map<String, Object>, RoutingDecoderNode.EventRouteLink>(){

            public RoutingDecoderNode.EventRouteLink adapt(Map<String, Object> a) {
                RoutingDecoderNode r = (RoutingDecoderNode)((Object)a.get(ReplicationReceiverLifecycleUtils.theRouter));
                ConsumerNode c = (ConsumerNode)a.get(ReplicationReceiverLifecycleUtils.theConsumer);
                return new RoutingDecoderNode.EventRouteLink(r, routeKey, c.getListener());
            }
        }, (Listener)new Listener<RoutingDecoderNode.EventRouteLink>(){

            public void handleEvent(RoutingDecoderNode.EventRouteLink input) {
                input.unlink();
            }
        }));
    }
}

