/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.demo.robot.replication.lifecycle;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.Session;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Source;
import org.jflux.api.core.chain.AdapterChain;
import org.jflux.api.core.config.Configuration;
import org.jflux.api.core.node.ConsumerNode;
import org.jflux.api.core.node.DefaultProcessorNode;
import org.jflux.api.core.node.ProcessorNode;
import org.jflux.api.core.node.chain.ConsumerChain;
import org.jflux.api.core.node.chain.NodeChainBuilder;
import org.jflux.api.core.playable.BasicPlayable;
import org.jflux.api.core.util.MapAdapter;
import org.jflux.api.core.util.Repeater;
import org.jflux.api.encode.EncodeRequest;
import org.jflux.avrogen.EventListRecord;
import org.jflux.avrogen.EventRecord;
import org.jflux.avrogen.HeaderRecord;
import org.jflux.impl.encode.avro.AvroEncoder;
import org.jflux.impl.messaging.JMSAvroUtils;
import org.jflux.impl.transport.jms.JMSMessageSender;
import org.jflux.impl.transport.jms.MessageHeaderAdapter;
import org.jflux.impl.transport.jms.MessagePacker;
import org.robokind.api.common.lifecycle.config.GenericLifecycle;
import org.robokind.api.common.lifecycle.config.RKDependencyConfigUtils;
import org.robokind.api.common.lifecycle.config.RKLifecycleConfigUtils;
import org.robokind.api.common.lifecycle.config.RKManagedGroupConfigUtils;
import org.robokind.demo.robot.replication.EventEncoder;

public class ReplicationSenderLifecycleUtils {
    private static final String theEncodeConfig = "encodeConfig";
    private static final String theDestination = "destination";
    private static final String theSession = "session";
    private static final String theMsgPacker = "msgPacker";
    private static final String theMsgHeader = "msgHeader";
    private static final String theMsgSender = "msgSender";
    private static final String theMsgPackerIdKey = "messagePackerId";
    private static final String theMsgHeaderIdKey = "messageHeaderAdapterId";
    private static final String theMsgSenderIdKey = "replicationSenderId";
    public static final String PROP_REPLICATION_SENDER_NODE_ID = "replicationNodeSenderId";
    public static final String DEFAULT_CONTENT_TYPE = "application/avro";

    public static List<Configuration<String>> getLifecycleConfigs(String encodeConfigIdKey, String encodeConfigId, String destinationIdKey, String destinationId, String sessionIdKey, String sessionId, String msgPackerId, String msgHeaderId, String replicationNodeId, String senderId) {
        return Arrays.asList(ReplicationSenderLifecycleUtils.buildMsgPackerLifecycleConfig(sessionIdKey, sessionId, msgPackerId), ReplicationSenderLifecycleUtils.buildMsgHeaderLifecycleConfig(encodeConfigIdKey, encodeConfigId, msgHeaderId), ReplicationSenderLifecycleUtils.buildSenderLifecycleConfig(destinationIdKey, destinationId, sessionIdKey, sessionId, senderId), ReplicationSenderLifecycleUtils.buildReplicationSenderLifecycleConfig(replicationNodeId, msgPackerId, msgHeaderId, senderId));
    }

    public static Adapter<List<EventRecord>, EventListRecord> eventListAdapter(String eventType, String sourceRef, Map<String, String> props) {
        return new EventEncoder.EventListEncoder(new EventEncoder.HeaderRecordSource(eventType, sourceRef, props));
    }

    public static Adapter<EventListRecord, ByteArrayOutputStream> listByteAdapter() {
        return new AdapterChain(EncodeRequest.factory((Source)new JMSAvroUtils.ByteOutputStreamFactory()), (Adapter)new AvroEncoder(EventListRecord.class, EventListRecord.SCHEMA$, false));
    }

    public static Configuration<String> buildMsgPackerLifecycleConfig(String sessionIdKey, String sessionId, String msgPackerId) {
        Configuration depConf = RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)theSession, Session.class, (String)sessionIdKey, (String)sessionId, null, null);
        return RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((Configuration)RKLifecycleConfigUtils.buildGenericLifecycleConfig((String[])new String[]{Adapter.class.getName(), MessagePacker.class.getName()}, (String)theMsgPackerIdKey, (String)msgPackerId, null, Arrays.asList(depConf), (Adapter)new MapAdapter.MapValueAdapter((Object)theSession, (Adapter)new Adapter<Session, MessagePacker>(){

            public MessagePacker adapt(Session a) {
                return new MessagePacker(a);
            }
        })));
    }

    public static Configuration<String> buildMsgHeaderLifecycleConfig(String encodeConfigIdKey, String encodeConfigId, String msgHeaderId) {
        Configuration depConf = RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)theEncodeConfig, Configuration.class, (String)encodeConfigIdKey, (String)encodeConfigId, null, null);
        return RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((Configuration)RKLifecycleConfigUtils.buildGenericLifecycleConfig((String[])new String[]{Adapter.class.getName(), MessageHeaderAdapter.class.getName()}, (String)theMsgHeaderIdKey, (String)msgHeaderId, null, Arrays.asList(depConf), (Adapter)new MapAdapter.MapValueAdapter((Object)theEncodeConfig, (Adapter)new Adapter<Configuration, MessageHeaderAdapter>(){

            public MessageHeaderAdapter adapt(Configuration a) {
                String ct = (String)a.getPropertyValue((Object)"serializationContentType");
                ct = ct == null ? ReplicationSenderLifecycleUtils.DEFAULT_CONTENT_TYPE : ct;
                return new MessageHeaderAdapter(ct);
            }
        })));
    }

    public static Configuration<String> buildSenderLifecycleConfig(String destinationIdKey, String destinationId, String sessionIdKey, String sessionId, String senderId) {
        List<Configuration> deps = Arrays.asList(RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)theDestination, Destination.class, (String)destinationIdKey, (String)destinationId, null, (Listener)new Listener<GenericLifecycle.DependencyChange<JMSMessageSender, Destination>>(){

            public void handleEvent(GenericLifecycle.DependencyChange<JMSMessageSender, Destination> input) {
                if (input.getService() != null) {
                    ((JMSMessageSender)input.getService()).setDestination((Destination)input.getDependency());
                }
            }
        }), RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)theSession, Session.class, (String)sessionIdKey, (String)sessionId, null, (Listener)new Listener<GenericLifecycle.DependencyChange<JMSMessageSender, Session>>(){

            public void handleEvent(GenericLifecycle.DependencyChange<JMSMessageSender, Session> input) {
                if (input.getService() != null) {
                    ((JMSMessageSender)input.getService()).setSession((Session)input.getDependency());
                }
            }
        }));
        return RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((Configuration)RKLifecycleConfigUtils.buildGenericLifecycleConfig((String[])new String[]{Listener.class.getName(), JMSMessageSender.class.getName()}, (String)theMsgSenderIdKey, (String)senderId, null, deps, (Adapter)new Adapter<Map<String, Object>, JMSMessageSender>(){

            public JMSMessageSender adapt(Map<String, Object> a) {
                Destination d = (Destination)a.get(ReplicationSenderLifecycleUtils.theDestination);
                Session s = (Session)a.get(ReplicationSenderLifecycleUtils.theSession);
                return new JMSMessageSender(s, d);
            }
        }));
    }

    public static Configuration<String> buildReplicationSenderLifecycleConfig(final String replicationNodeId, String msgPackerId, String msgHeaderId, String senderId) {
        List<Configuration> deps = Arrays.asList(RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)theMsgPacker, MessagePacker.class, (String)theMsgPackerIdKey, (String)msgPackerId, null, null), RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)theMsgHeader, MessageHeaderAdapter.class, (String)theMsgHeaderIdKey, (String)msgHeaderId, null, null), RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)theMsgSender, JMSMessageSender.class, (String)theMsgSenderIdKey, (String)senderId, null, null));
        return RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((Configuration)RKLifecycleConfigUtils.buildGenericLifecycleConfig((String[])new String[]{ConsumerNode.class.getName(), ReplicationSender.class.getName()}, (String)PROP_REPLICATION_SENDER_NODE_ID, (String)replicationNodeId, null, deps, (Adapter)new Adapter<Map<String, Object>, ReplicationSender>(){

            public ReplicationSender adapt(Map<String, Object> a) {
                MessagePacker msgPacker = (MessagePacker)a.get(ReplicationSenderLifecycleUtils.theMsgPacker);
                MessageHeaderAdapter headerAdapter = (MessageHeaderAdapter)a.get(ReplicationSenderLifecycleUtils.theMsgHeader);
                JMSMessageSender sender = (JMSMessageSender)a.get(ReplicationSenderLifecycleUtils.theMsgSender);
                ReplicationSender s = new ReplicationSender(replicationNodeId, EventListRecord.class.getSimpleName(), null, msgPacker, headerAdapter, sender);
                s.start();
                return s;
            }
        }, (Listener)new Listener<ReplicationSender>(){

            public void handleEvent(ReplicationSender input) {
                input.stop();
            }
        }));
    }

    static class LoggingListener
    implements Listener<List<EventRecord>> {
        LoggingListener() {
        }

        public void handleEvent(List<EventRecord> input) {
            if (input == null || input.isEmpty()) {
                System.out.println("No events to send");
                return;
            }
            StringBuilder sb = new StringBuilder("Sending Events:");
            for (EventRecord r : input) {
                this.addEventString(r, sb);
            }
            System.out.println(sb.toString());
        }

        private void addEventString(EventRecord r, StringBuilder sb) {
            if (r == null) {
                sb.append("\nnull");
                return;
            }
            HeaderRecord h = r.getHeader();
            if (h == null || h.getEventType() == null) {
                sb.append("\nunknown");
                return;
            }
            sb.append("\n").append(h.getEventType());
            if (h.getTimestamp() != null) {
                sb.append(", event time: ").append(h.getTimestamp().toString());
            }
        }
    }

    private static class ReplicationSender
    extends BasicPlayable
    implements ConsumerNode<List<EventRecord>> {
        private Adapter<List<EventRecord>, EventListRecord> myEventListAdapter;
        private Adapter<EventListRecord, ByteArrayOutputStream> myEncoder;
        private Adapter<ByteArrayOutputStream, BytesMessage> myMessagePacker;
        private Adapter<BytesMessage, BytesMessage> myMessageHeaderAdapter;
        private Listener<BytesMessage> myMessageSender;
        private Listener<List<EventRecord>> mySenderChain;

        public ReplicationSender(String replicationNodeId, String eventListType, Map<String, String> listProps, MessagePacker msgPacker, MessageHeaderAdapter headerAdapter, JMSMessageSender sender) {
            this.myEventListAdapter = ReplicationSenderLifecycleUtils.eventListAdapter(eventListType, replicationNodeId, listProps);
            this.myEncoder = ReplicationSenderLifecycleUtils.listByteAdapter();
            this.myMessagePacker = msgPacker;
            this.myMessageHeaderAdapter = headerAdapter;
            this.myMessageSender = sender;
            DefaultProcessorNode a = new DefaultProcessorNode(AdapterChain.builder(this.myEventListAdapter).attach(this.myEncoder).attach(this.myMessagePacker).attach(this.myMessageHeaderAdapter).done());
            ConsumerChain n = NodeChainBuilder.build((ProcessorNode)a).getConsumerChain(this.myMessageSender);
            Repeater repeater = new Repeater();
            repeater.addListener(n.getListener());
            this.mySenderChain = repeater;
            n.start();
        }

        public Listener<List<EventRecord>> getListener() {
            return this.mySenderChain;
        }
    }
}

