/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.demo.robot.replication;

import java.nio.ByteBuffer;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.jflux.api.core.chain.AdapterChain;
import org.jflux.api.core.chain.ListenerChain;
import org.jflux.api.core.event.Event;
import org.jflux.api.core.event.Header;
import org.jflux.api.core.node.DefaultConsumerNode;
import org.jflux.api.data.routing.Router;
import org.robokind.demo.robot.replication.EventDecoder;

public class RoutingDecoderNode
extends DefaultConsumerNode<Event<Header, ByteBuffer>> {
    private Router.DefaultRouter<String, Event<Header, ByteBuffer>> myDecodingRouter;
    private Router.DefaultRouter<String, Event<Header, ?>> myEventRouter;

    public static RoutingDecoderNode makeDefault() {
        return new RoutingDecoderNode((Router.DefaultRouter<String, Event<Header, ByteBuffer>>)new Router.DefaultRouter((Adapter)new AdapterChain((Adapter)new Event.EventHeaderAdapter(), (Adapter)new Header.HeaderPropertyAdapter("serializationMessageClass"))));
    }

    RoutingDecoderNode(Router.DefaultRouter<String, Event<Header, ByteBuffer>> decoder) {
        super(decoder);
        this.myDecodingRouter = decoder;
        this.myEventRouter = new Router.DefaultRouter((Adapter)new AdapterChain((Adapter)new Event.EventHeaderAdapter(), (Adapter)new Header.HeaderTypeAdapter()));
    }

    <T> void addDecodingRoute(String msgClassString, Adapter<ByteBuffer, T> decoder) {
        EventDecoder eventDecoder = new EventDecoder(decoder);
        ListenerChain listener = new ListenerChain(eventDecoder, this.myEventRouter);
        this.myDecodingRouter.addRoute((Object)msgClassString, (Listener)listener);
    }

    void removeDecodingRoute(String msgClassString) {
        this.myDecodingRouter.removeRoute((Object)msgClassString);
    }

    void addEventRoute(String eventKey, Listener<Event<Header, ?>> listener) {
        this.myEventRouter.addRoute((Object)eventKey, listener);
    }

    void removeEventRoute(String eventKey) {
        this.myEventRouter.removeRoute((Object)eventKey);
    }

    public static class EventRouteLink<T> {
        private RoutingDecoderNode myRoutingDecoder;
        private String myRoutingKey;
        private Listener<Event<Header, T>> myEventRoute;

        public EventRouteLink(RoutingDecoderNode routingDecoder, String routingKey, Listener<Event<Header, T>> eventRoute) {
            this.myRoutingDecoder = routingDecoder;
            this.myRoutingKey = routingKey;
            this.myEventRoute = eventRoute;
            this.link();
        }

        public void setRoutingDecoder(RoutingDecoderNode routingDecoder) {
            this.unlink();
            this.myRoutingDecoder = routingDecoder;
            this.link();
        }

        public void setRoute(String routingKey, Listener<Event<Header, T>> eventRoute) {
            this.unlink();
            this.myRoutingKey = routingKey;
            this.myEventRoute = eventRoute;
            this.link();
        }

        public void link() {
            if (this.myRoutingDecoder == null || this.myEventRoute == null || this.myRoutingKey == null) {
                return;
            }
            this.myRoutingDecoder.addEventRoute(this.myRoutingKey, this.myEventRoute);
        }

        public void unlink() {
            if (this.myRoutingDecoder == null || this.myRoutingKey == null) {
                return;
            }
            this.myRoutingDecoder.removeEventRoute(this.myRoutingKey);
        }
    }

    public static class DecoderLink<T> {
        private RoutingDecoderNode myRoutingDecoder;
        private String myDecoderKey;
        private Adapter<ByteBuffer, T> myDecoder;

        public DecoderLink(RoutingDecoderNode routingDecoder, String decoderKey, Adapter<ByteBuffer, T> decoder) {
            this.myRoutingDecoder = routingDecoder;
            this.myDecoderKey = decoderKey;
            this.myDecoder = decoder;
            this.link();
        }

        public void setRoutingDecoder(RoutingDecoderNode routingDecoder) {
            this.unlink();
            this.myRoutingDecoder = routingDecoder;
            this.link();
        }

        public void setDecoder(String decoderKey, Adapter<ByteBuffer, T> decoder) {
            this.unlink();
            this.myDecoderKey = decoderKey;
            this.myDecoder = decoder;
            this.link();
        }

        public void link() {
            if (this.myRoutingDecoder == null || this.myDecoder == null || this.myDecoderKey == null) {
                return;
            }
            this.myRoutingDecoder.addDecodingRoute(this.myDecoderKey, this.myDecoder);
        }

        public void unlink() {
            if (this.myRoutingDecoder == null || this.myDecoderKey == null) {
                return;
            }
            this.myRoutingDecoder.removeDecodingRoute(this.myDecoderKey);
        }
    }
}

