/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.demo.robot.replication.lifecycle;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jflux.api.core.Source;
import org.jflux.api.core.config.Configuration;
import org.jflux.avrogen.EventListRecord;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.lifecycle.config.RKManagedGroupConfigUtils;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.demo.robot.replication.lifecycle.CollectorLifecycleUtils;
import org.robokind.demo.robot.replication.lifecycle.EventBufferUtils;
import org.robokind.demo.robot.replication.lifecycle.ReplicationSenderLifecycleUtils;
import org.robokind.impl.messaging.config.MessagingLifecycleGroupConfigUtils;

public class ReplicationSenderGroupLifecycleUtils {
    public static final String EVENT_LIST_RECORD_ENCODE_CONFIG_FULL_ID = EventListRecord.class.toString();
    public static final String REPLICATION_DESTINATION_ID = "replicationDestinationId";
    public static final String REPLICATION_CONNECTION_ID = "replicationConnectionId";
    public static final String REPLICATION_SESSION_ID = "replicationSessionId";
    public static final String MESSAGE_PACKER_ID = "messagePackerId";
    public static final String MESSAGE_HEADER_ID = "messageHeaderId";
    public static final String REMOTE_REPLICATION_NODE_ID = "replicationNodeSenderId";
    public static final String REPLICATION_SENDER_ID = "replicationSenderId";
    public static final String BUF_EVENT_FACTORY_ID = "bufEventFactoryId";
    public static final String BUF_EVENT_ENCODER_ID = "bufEventEncodeId";
    public static final String EVENT_COLLECTOR_ID = "eventCollectorId";
    public static final String EVENT_BUFFER_TRACKER_ID = "eventBufferTrackerId";
    public static final String LINK_SENDER_ID = "senderLinkId";
    public static final String LINK_COLLECTION_TIMER_ID = "collectionTimerLinkId";
    public static final String COLLECTION_TIMER_ID = "collectionTimerId";
    public static final String GROUP_TYPE = "ReplicationSenderGroup";
    private static final String theIdFormat = "%s/ReplicationSenderGroup/%s";

    public static String id(String groupId, String part) {
        return String.format(theIdFormat, groupId, part);
    }

    public static List<Configuration<String>> getReplicationSenderLifecycleConfigs(String groupId) {
        return ReplicationSenderLifecycleUtils.getLifecycleConfigs("messagingSerializationConfig", EVENT_LIST_RECORD_ENCODE_CONFIG_FULL_ID, "destinationId", ReplicationSenderGroupLifecycleUtils.id(groupId, REPLICATION_DESTINATION_ID), "connectionId", ReplicationSenderGroupLifecycleUtils.id(groupId, REPLICATION_SESSION_ID), ReplicationSenderGroupLifecycleUtils.id(groupId, MESSAGE_PACKER_ID), ReplicationSenderGroupLifecycleUtils.id(groupId, MESSAGE_HEADER_ID), ReplicationSenderGroupLifecycleUtils.id(groupId, REMOTE_REPLICATION_NODE_ID), ReplicationSenderGroupLifecycleUtils.id(groupId, REPLICATION_SENDER_ID));
    }

    public static List<Configuration<String>> getJMSLifecycleConfigs(String groupId, String destinationConfId, String connectionConfId) {
        ArrayList<Configuration<String>> l = new ArrayList<Configuration<String>>();
        l.add(RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((Configuration)MessagingLifecycleGroupConfigUtils.buildDestinationLifecycleConfig((String)destinationConfId, (String)ReplicationSenderGroupLifecycleUtils.id(groupId, REPLICATION_DESTINATION_ID))));
        l.add(RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((Configuration)MessagingLifecycleGroupConfigUtils.buildConnectionLifecycleConfig((String)connectionConfId, (String)ReplicationSenderGroupLifecycleUtils.id(groupId, REPLICATION_CONNECTION_ID))));
        l.add(RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((Configuration)MessagingLifecycleGroupConfigUtils.buildSessionLifecycleConfig((String)ReplicationSenderGroupLifecycleUtils.id(groupId, REPLICATION_CONNECTION_ID), (String)ReplicationSenderGroupLifecycleUtils.id(groupId, REPLICATION_SESSION_ID))));
        return l;
    }

    public static List<Configuration<String>> getReplicationBufferLifecycleConfigs(String groupId, String eventBufferId, String encodeConfigId, Properties bufferProps, int bufferCapacity) {
        return EventBufferUtils.getLifecycleConfigs("messagingSerializationConfig", encodeConfigId, ReplicationSenderGroupLifecycleUtils.id(groupId, eventBufferId + "/" + BUF_EVENT_FACTORY_ID), eventBufferId, groupId, ReplicationSenderGroupLifecycleUtils.id(groupId, eventBufferId + "/" + BUF_EVENT_ENCODER_ID), eventBufferId, bufferProps, bufferCapacity);
    }

    public static List<Configuration<String>> getAlternateReplicationBufferLifecycleConfigs(String groupId, String eventBufferId, String encodeConfigId, Source valueSource) {
        return EventBufferUtils.getAlternateLifecycleConfigs("messagingSerializationConfig", encodeConfigId, ReplicationSenderGroupLifecycleUtils.id(groupId, eventBufferId + "/" + BUF_EVENT_FACTORY_ID), eventBufferId, groupId, ReplicationSenderGroupLifecycleUtils.id(groupId, eventBufferId + "/" + BUF_EVENT_ENCODER_ID), eventBufferId, valueSource);
    }

    public static List<Configuration<String>> getCollectorLifecycleConfigs(String groupId, BundleContext context, Properties collectorProps, long initialDelay, long period, Properties timerProps) {
        return CollectorLifecycleUtils.buildTimedCollector(context, EVENT_COLLECTOR_ID, ReplicationSenderGroupLifecycleUtils.id(groupId, EVENT_COLLECTOR_ID), collectorProps, EVENT_BUFFER_TRACKER_ID, ReplicationSenderGroupLifecycleUtils.id(groupId, EVENT_BUFFER_TRACKER_ID), OSGiUtils.createFilter((String)"serviceGroupId", (String)groupId), LINK_SENDER_ID, REMOTE_REPLICATION_NODE_ID, ReplicationSenderGroupLifecycleUtils.id(groupId, REMOTE_REPLICATION_NODE_ID), LINK_COLLECTION_TIMER_ID, COLLECTION_TIMER_ID, ReplicationSenderGroupLifecycleUtils.id(groupId, COLLECTION_TIMER_ID), initialDelay, period, timerProps);
    }
}

