/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.demo.robot.replication.lifecycle;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Source;
import org.jflux.api.core.config.Configuration;
import org.jflux.api.core.node.Node;
import org.jflux.api.core.node.ProcessorNode;
import org.jflux.api.core.node.ProducerNode;
import org.jflux.api.core.util.DefaultSource;
import org.jflux.api.core.util.MapAdapter;
import org.jflux.api.data.blend.DataCollector;
import org.jflux.api.schedule.HeartbeatNode;
import org.jflux.impl.services.rk.lifecycle.config.RKDependencyConfigUtils;
import org.jflux.impl.services.rk.lifecycle.config.RKLifecycleConfigUtils;
import org.jflux.impl.services.rk.lifecycle.config.RKManagedGroupConfigUtils;
import org.osgi.framework.BundleContext;
import org.robokind.demo.robot.replication.EventListCollector;
import org.robokind.demo.robot.replication.chain.NodeLinkLifecycleUtils;

public class CollectorLifecycleUtils {
    private static final String theCollector = "encodeConfig";

    public static List<Configuration<String>> buildTimedCollector(BundleContext context, String collectorIdKey, String collectorId, Properties collectorProps, String trackerIdKey, String trackerId, String bufferFilterString, String senderLinkId, String senderNodeIdKey, String senderNodeId, String timerlinkId, String timerNodeIdKey, String timerNodeId, long initialDelay, long period, Properties timerProps) {
        return Arrays.asList(CollectorLifecycleUtils.buildEventCollectorLifecycleConfig(collectorIdKey, collectorId, collectorProps), CollectorLifecycleUtils.buildBufferTrackerLifecycleConfig(context, collectorIdKey, collectorId, trackerIdKey, trackerId, bufferFilterString), CollectorLifecycleUtils.buildSenderLinkLifecycleConfig(senderLinkId, collectorIdKey, collectorId, senderNodeIdKey, senderNodeId), CollectorLifecycleUtils.buildIntervalTimerLifecycleConfig(timerNodeIdKey, timerNodeId, initialDelay, period, timerProps), CollectorLifecycleUtils.buildCollectionTriggerLinkLifecycleConfig(timerlinkId, timerNodeIdKey, timerNodeId, collectorIdKey, collectorId));
    }

    public static Configuration<String> buildEventCollectorLifecycleConfig(String collectorIdKey, String collectorId, Properties props) {
        String[] classNames = new String[]{ProcessorNode.class.getName(), EventListCollector.class.getName(), DataCollector.class.getName()};
        if (props == null) {
            props = new Properties();
        }
        props.put(collectorIdKey, collectorId);
        return RKManagedGroupConfigUtils.makeSimpleSelfBuildingLifecycle((String[])classNames, (Object)((Object)EventListCollector.buildDefault()), (String)collectorIdKey, (String)collectorId, (Properties)props);
    }

    public static Configuration<String> buildBufferTrackerLifecycleConfig(final BundleContext context, String collectorIdKey, String collectorId, String trackerIdKey, String trackerId, final String bufferFilterString) {
        Configuration depConf = RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)theCollector, EventListCollector.class, (String)collectorIdKey, (String)collectorId, null, null);
        return RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((Configuration)RKLifecycleConfigUtils.buildGenericLifecycleConfig((String[])new String[]{EventListCollector.EventBufferTracker.class.getName()}, (String)trackerIdKey, (String)trackerId, null, Arrays.asList(depConf), (Adapter)new MapAdapter.MapValueAdapter((Object)theCollector, (Adapter)new Adapter<EventListCollector, EventListCollector.EventBufferTracker>(){

            public EventListCollector.EventBufferTracker adapt(EventListCollector a) {
                EventListCollector.EventBufferTracker t = new EventListCollector.EventBufferTracker(context, bufferFilterString, a);
                t.start();
                return t;
            }
        }), (Listener)new Listener<EventListCollector.EventBufferTracker>(){

            public void handleEvent(EventListCollector.EventBufferTracker input) {
                input.stop();
            }
        }));
    }

    public static Configuration<String> buildSenderLinkLifecycleConfig(String linkId, String collectorIdKey, String collectorId, String senderNodeIdKey, String senderNodeId) {
        return NodeLinkLifecycleUtils.processorConsumerLinkLifecycleConfig(linkId, null, collectorIdKey, collectorId, null, senderNodeIdKey, senderNodeId, null);
    }

    public static Configuration<String> buildCollectionTriggerLinkLifecycleConfig(String linkId, String producerNodeIdKey, String producerNodeId, String collectorIdKey, String collectorId) {
        return NodeLinkLifecycleUtils.producerProcessorLinkLifecycleConfig(linkId, null, producerNodeIdKey, producerNodeId, null, collectorIdKey, collectorId, null);
    }

    public static Configuration<String> buildIntervalTimerLifecycleConfig(String timerIdKey, String timerId, final long initialDelay, final long period, final Source messageSource, Properties props) {
        String[] classNames = new String[]{HeartbeatNode.class.getName(), ProducerNode.class.getName(), Node.class.getName()};
        return RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((Configuration)RKLifecycleConfigUtils.buildGenericLifecycleConfig((String[])classNames, (String)timerIdKey, (String)timerId, (Properties)props, (Iterable)Collections.EMPTY_LIST, (Adapter)new Adapter<Map<String, Object>, HeartbeatNode>(){

            public HeartbeatNode adapt(Map<String, Object> a) {
                HeartbeatNode h = new HeartbeatNode((Source)(messageSource == null ? new DefaultSource(new Object()) : messageSource), initialDelay, period, TimeUnit.MILLISECONDS);
                h.start();
                return h;
            }
        }, (Listener)new Listener<HeartbeatNode>(){

            public void handleEvent(HeartbeatNode input) {
                input.stop();
            }
        }));
    }

    public static Configuration<String> buildIntervalTimerLifecycleConfig(String timerIdKey, String timerId, long initialDelay, long period, Properties props) {
        return CollectorLifecycleUtils.buildIntervalTimerLifecycleConfig(timerIdKey, timerId, initialDelay, period, null, props);
    }
}

