/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.demo.robot.replication;

import java.util.Arrays;
import java.util.List;
import org.jflux.api.core.Listener;
import org.jflux.api.core.config.Configuration;
import org.jflux.api.core.event.Event;
import org.jflux.api.core.event.Header;
import org.jflux.api.core.node.ConsumerNode;
import org.jflux.api.core.node.DefaultConsumerNode;
import org.jflux.api.core.util.ListMergeAdapter;
import org.jflux.impl.services.rk.lifecycle.config.RKManagedGroupConfigUtils;
import org.jflux.impl.services.rk.lifecycle.utils.ManagedServiceFactory;
import org.jflux.impl.services.rk.lifecycle.utils.ManagedServiceGroup;
import org.robokind.api.messaging.services.ServiceCommand;
import org.robokind.api.messaging.services.ServiceError;
import org.robokind.demo.robot.replication.lifecycle.ReplicationReceiverGroupLifecycleUtils;
import org.robokind.impl.messaging.config.RKMessagingConfigUtils;

public class ReceiverTest {
    private static final String theGroupId = "receiverGroup";
    private static final String theConnectConfigId = "testConnectConfig";
    private static final String theDestConfigId = "receiverDestConfig";
    private static final String theRouteConsumerIdKey = "routeConsumerId";

    public static <T> void createRoute(String theRoutingKey, String theEncodeConfigId, ConsumerNode<Event<Header<String, Long>, T>> logger, ManagedServiceFactory fact) {
        List<Configuration> configs = Arrays.asList(ReplicationReceiverGroupLifecycleUtils.getReplicationRouteLinkLifecycleConfig(theGroupId, theRoutingKey + "LinkId", theRoutingKey, theRouteConsumerIdKey, theRoutingKey + "ConsumerId"), ReplicationReceiverGroupLifecycleUtils.getReplicationDecoderLinkLifecycleConfig(theGroupId, theRoutingKey + "DecoderId", theEncodeConfigId), RKManagedGroupConfigUtils.makeSimpleSelfBuildingLifecycle((String[])new String[]{ConsumerNode.class.getName()}, logger, (String)theRouteConsumerIdKey, (String)(theRoutingKey + "ConsumerId"), null));
        Configuration groupConf = RKManagedGroupConfigUtils.buildManagedGroupConfig((String)theGroupId, null, configs);
        ManagedServiceGroup group = RKManagedGroupConfigUtils.buildGroup((ManagedServiceFactory)fact, (Configuration)groupConf);
        group.start();
    }

    public static void start(ManagedServiceFactory fact) {
        RKMessagingConfigUtils.registerQueueConfig((String)theDestConfigId, (String)"test", null, (ManagedServiceFactory)fact);
        List<Configuration<String>> lifecycles = ReceiverTest.getLifecycleConfigs(theGroupId, theConnectConfigId, theDestConfigId);
        Configuration groupConf = RKManagedGroupConfigUtils.buildManagedGroupConfig((String)theGroupId, null, lifecycles);
        ManagedServiceGroup group = RKManagedGroupConfigUtils.buildGroup((ManagedServiceFactory)fact, (Configuration)groupConf);
        group.start();
    }

    private static List<Configuration<String>> getLifecycleConfigs(String groupId, String connectionConfigId, String destConfigId) {
        return new ListMergeAdapter().adapt(Arrays.asList(ReplicationReceiverGroupLifecycleUtils.getJMSLifecycleConfigs(groupId, destConfigId, connectionConfigId), ReplicationReceiverGroupLifecycleUtils.getReplicationReceiverLifecycleConfigs(groupId)));
    }

    public static class TestErrorLogger
    extends DefaultConsumerNode<Event<Header<String, Long>, ServiceError>> {
        public TestErrorLogger() {
            super((Listener)new Listener<Event<Header<String, Long>, ServiceError>>(){

                public void handleEvent(Event<Header<String, Long>, ServiceError> input) {
                    Header h = (Header)input.getHeader();
                    ServiceError e = (ServiceError)input.getData();
                    long now = System.currentTimeMillis();
                    System.out.println("Event Type: " + h.getEventType() + "\n" + "Timestamp: " + h.getTimestamp() + " (elapsed: " + (now - (Long)h.getTimestamp()) + ", now:" + now + ")\n" + "Source Reference: " + (String)h.getSourceReference() + "\n" + "Error Type: " + e.getErrorType() + "\n" + "Error Message: " + e.getMessage() + "\n" + "Error Details: " + e.getDetails() + "\n");
                }
            });
            this.start();
        }
    }

    public static class TestEventLogger
    extends DefaultConsumerNode<Event<Header<String, Long>, ServiceCommand>> {
        public TestEventLogger() {
            super((Listener)new Listener<Event<Header<String, Long>, ServiceCommand>>(){

                public void handleEvent(Event<Header<String, Long>, ServiceCommand> input) {
                    Header h = (Header)input.getHeader();
                    ServiceCommand s = (ServiceCommand)input.getData();
                    long now = System.currentTimeMillis();
                    System.out.println("Event Type: " + h.getEventType() + "\n" + "Timestamp: " + h.getTimestamp() + " (elapsed: " + (now - (Long)h.getTimestamp()) + ", now:" + now + ")\n" + "Source Reference: " + (String)h.getSourceReference() + "\n" + "Command Type: " + s.getCommand() + "\n");
                }
            });
            this.start();
        }
    }
}

