/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.demo.robot.replication;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.apache.avro.Schema;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.config.Configuration;
import org.jflux.avrogen.DoubleRecord;
import org.jflux.avrogen.EventListRecord;
import org.jflux.avrogen.EventRecord;
import org.jflux.avrogen.HeaderRecord;
import org.jflux.impl.messaging.rk.config.RKMessagingConfigUtils;
import org.jflux.impl.services.rk.lifecycle.config.RKManagedGroupConfigUtils;
import org.jflux.impl.services.rk.lifecycle.utils.ManagedServiceFactory;
import org.jflux.impl.services.rk.lifecycle.utils.ManagedServiceGroup;
import org.jflux.impl.services.rk.osgi.lifecycle.OSGiComponentFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.position.DoubleRange;
import org.robokind.api.common.position.NormalizableRange;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.utils.Utils;
import org.robokind.api.motion.AbstractJoint;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.JointProperty;
import org.robokind.api.motion.messaging.RemoteJointProperty;
import org.robokind.demo.robot.replication.RobotReplicator;
import org.robokind.demo.robot.replication.messaging.PortableNormalizedDouble;

public class Activator
implements BundleActivator {
    private static final String theGroupId = "robotReplicationDemoGroup";

    public void start(BundleContext bc) throws Exception {
        String destConfigId = "robotReplicationDestinationConfig";
        OSGiComponentFactory fact = new OSGiComponentFactory(bc);
        this.registerEncodingConfigs((ManagedServiceFactory)fact);
        RKMessagingConfigUtils.registerConnectionConfig((String)"robotReplicationConnectionConfig", (String)"127.0.0.1", null, (ManagedServiceFactory)fact);
        RKMessagingConfigUtils.registerTopicConfig((String)destConfigId, (String)"robotReplication", null, (ManagedServiceFactory)fact);
        this.replicate(bc, (ManagedServiceFactory)fact, "robotReplicationConnectionConfig", "robotReceiverConnectionConfig", destConfigId, 200L);
    }

    private void replicate(BundleContext context, ManagedServiceFactory fact, String replicationConnectConfigId, String receiverConnectConfigId, String destConfigId, long replicationPeriod) {
        ArrayList<Configuration<String>> configs = new ArrayList<Configuration<String>>();
        configs.add(RobotReplicator.buildRobotReceiverLifecycleConfig(context, receiverConnectConfigId, destConfigId));
        configs.add(RobotReplicator.buildRobotReplicationLifecycleConfig(context, replicationConnectConfigId, destConfigId, replicationPeriod));
        Configuration groupConf = RKManagedGroupConfigUtils.buildManagedGroupConfig((String)theGroupId, null, configs);
        ManagedServiceGroup group = RKManagedGroupConfigUtils.buildGroup((ManagedServiceFactory)fact, (Configuration)groupConf);
        group.start();
    }

    private void test(BundleContext bc, ManagedServiceFactory fact, String connectConfigId, String destConfigId) {
        RJoint1 j1a = new RJoint1(0);
        RJoint1 j1b = new RJoint1(1);
        RJoint1 j1c = new RJoint1(2);
        RJoint2 j2a = new RJoint2(0);
        RJoint2 j2b = new RJoint2(1);
        RJoint2 j2c = new RJoint2(2);
        RobotReplicator.startRobotReplicator(bc, theGroupId, connectConfigId, destConfigId, Arrays.asList(new Joint[]{j1a, j1b, j1c}), 100L, null, fact);
        RobotReplicator.startRobotReceiver(theGroupId, connectConfigId, destConfigId, Arrays.asList(new Joint[]{j2a, j2b, j2c}), null, fact);
    }

    public void stop(BundleContext context) throws Exception {
    }

    private void registerEncodingConfigs(ManagedServiceFactory fact) {
        RKMessagingConfigUtils.registerAvroSerializationConfig(EventListRecord.class, EventListRecord.class, (Schema)EventListRecord.SCHEMA$, null, null, (String)"application/avro-event-list", null, (ManagedServiceFactory)fact);
        RKMessagingConfigUtils.registerAvroSerializationConfig(EventRecord.class, EventRecord.class, (Schema)EventRecord.SCHEMA$, null, null, (String)"application/avro-event", null, (ManagedServiceFactory)fact);
        RKMessagingConfigUtils.registerAvroSerializationConfig(HeaderRecord.class, HeaderRecord.class, (Schema)HeaderRecord.SCHEMA$, null, null, (String)"application/avro-header", null, (ManagedServiceFactory)fact);
        RKMessagingConfigUtils.registerAvroSerializationConfig(NormalizedDouble.class, DoubleRecord.class, (Schema)DoubleRecord.SCHEMA$, (Adapter)new PortableNormalizedDouble.MessageRecordAdapter(), (Adapter)new PortableNormalizedDouble.RecordMessageAdapter(), (String)"application/avro", null, (ManagedServiceFactory)fact);
    }

    static class RJoint2
    extends RJoint {
        public RJoint2(int id) {
            super(id);
            this.addProperty((JointProperty)new RemoteJointProperty("currentPosition", "currentPosition", NormalizedDouble.class, (Object)new NormalizedDouble(0.0), (NormalizableRange)new NormalizableRange.DefaultRange()));
        }
    }

    static class RJoint1
    extends RJoint {
        public RJoint1(final int id) {
            super(id);
            final Random rand = new Random();
            this.addProperty((JointProperty)new RemoteJointProperty("currentPosition", "currentPosition", NormalizedDouble.class, new NormalizedDouble(0.0), (NormalizableRange)new NormalizableRange.DefaultRange()){

                public NormalizedDouble getValue() {
                    double x = rand.nextDouble();
                    double j = (double)id / 10.0;
                    x /= 100.0;
                    return new NormalizedDouble(Utils.bound((double)(x += j), (double)0.0, (double)1.0));
                }
            });
        }
    }

    static class RJoint
    extends AbstractJoint {
        public RJoint(int id) {
            super(new Joint.Id(id));
            this.addProperty((JointProperty)new RemoteJointProperty("test", "test", NormalizedDouble.class, (Object)new NormalizedDouble(0.2), (NormalizableRange)new NormalizableRange.DefaultRange()));
        }

        public String getName() {
            return "name";
        }

        public NormalizedDouble getDefaultPosition() {
            return new NormalizedDouble(0.5);
        }

        public NormalizableRange<Double> getPositionRange() {
            return new DoubleRange(0.0, 1.0);
        }

        public NormalizedDouble getGoalPosition() {
            return new NormalizedDouble(0.2);
        }

        public void setEnabled(Boolean enabled) {
        }

        public Boolean getEnabled() {
            return true;
        }
    }
}

