/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.demo.robot.replication;

import java.util.List;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Source;
import org.jflux.api.core.chain.SourceChain;
import org.jflux.api.core.node.DefaultProcessorNode;
import org.jflux.api.core.util.ListMergeAdapter;
import org.jflux.api.core.util.SourceAdapter;
import org.jflux.api.data.blend.DataCollector;
import org.jflux.avrogen.EventRecord;
import org.jflux.impl.services.rk.osgi.ServiceClassListener;
import org.osgi.framework.BundleContext;
import org.robokind.demo.robot.replication.lifecycle.EventBufferUtils;

public class EventListCollector
extends DefaultProcessorNode<Object, List<EventRecord>>
implements DataCollector<EventRecord, List<EventRecord>> {
    private DataCollector<List<EventRecord>, List<List<EventRecord>>> myEventListCollector;
    private DataCollector.DefaultCollector<EventRecord> myEventCollector;
    private Source<List<EventRecord>> myEventsSource;

    public static EventListCollector buildDefault() {
        DataCollector.DefaultCollector col = new DataCollector.DefaultCollector();
        EventListCollector c = new EventListCollector((DataCollector<List<EventRecord>, List<List<EventRecord>>>)col, (Source<List<EventRecord>>)SourceChain.builder((Source)col).attach((Adapter)new ListMergeAdapter()).done());
        c.start();
        return c;
    }

    EventListCollector(DataCollector<List<EventRecord>, List<List<EventRecord>>> listCollector, Source<List<EventRecord>> adaptedCollector) {
        super((Adapter)new SourceAdapter(adaptedCollector));
        this.myEventListCollector = listCollector;
        this.myEventsSource = adaptedCollector;
        this.myEventCollector = new DataCollector.DefaultCollector();
        this.myEventListCollector.addSource(this.myEventCollector);
    }

    public Source<List<EventRecord>> getRecordSource() {
        return this.myEventsSource;
    }

    public void addListSource(Source<List<EventRecord>> source) {
        this.myEventListCollector.addSource(source);
    }

    public void addSource(Source<EventRecord> source) {
        this.myEventCollector.addSource(source);
    }

    public void removeListSource(Source<List<EventRecord>> source) {
        this.myEventListCollector.addSource(source);
    }

    public void removeSource(Source<EventRecord> source) {
        this.myEventCollector.addSource(source);
    }

    public List<EventRecord> getValue() {
        return (List)this.myEventsSource.getValue();
    }

    public static class EventBufferTracker
    extends ServiceClassListener<EventBufferUtils.EventBuffer> {
        private EventListCollector myCollector;

        public EventBufferTracker(BundleContext context, String filterString, EventListCollector collector) {
            super(EventBufferUtils.EventBuffer.class, context, filterString);
            if (collector == null) {
                throw new NullPointerException();
            }
            this.myCollector = collector;
        }

        protected void addService(EventBufferUtils.EventBuffer t) {
            if (t == null || t.getRecordValues() == null) {
                return;
            }
            this.myCollector.addListSource(t.getRecordValues());
        }

        protected void removeService(EventBufferUtils.EventBuffer t) {
            if (t == null || t.getRecordValues() == null) {
                return;
            }
            this.myCollector.removeListSource(t.getRecordValues());
        }
    }
}

