/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.demo.robot.replication;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jflux.api.core.Source;
import org.jflux.api.core.config.Configuration;
import org.jflux.api.core.util.ListMergeAdapter;
import org.jflux.impl.messaging.rk.config.RKMessagingConfigUtils;
import org.jflux.impl.services.rk.lifecycle.config.RKManagedGroupConfigUtils;
import org.jflux.impl.services.rk.lifecycle.utils.ManagedServiceFactory;
import org.jflux.impl.services.rk.lifecycle.utils.ManagedServiceGroup;
import org.osgi.framework.BundleContext;
import org.robokind.api.messaging.services.ServiceCommand;
import org.robokind.demo.robot.replication.chain.NodeLinkLifecycleUtils;
import org.robokind.demo.robot.replication.lifecycle.ReplicationReceiverGroupLifecycleUtils;
import org.robokind.demo.robot.replication.lifecycle.ReplicationSenderGroupLifecycleUtils;

public class ReplicationUtils {
    public static final String BUFFER_LINK_ID_SUFFIX = "LinkId";
    public static final String ROUTE_LINK_ID_SUFFIX = "LinkId";
    public static final String DECODER_LINK_ID_SUFFIX = "DecoderId";

    private void initializeTest(BundleContext context, String groupId, String ipAddress, String destName, ManagedServiceFactory fact) {
        String connectConfigId = groupId + "ConnectConfig";
        String destConfigId = groupId + "DestConfig";
        RKMessagingConfigUtils.registerConnectionConfig((String)connectConfigId, (String)ipAddress, null, (ManagedServiceFactory)fact);
        RKMessagingConfigUtils.registerQueueConfig((String)destConfigId, (String)destName, null, (ManagedServiceFactory)fact);
        ReplicationUtils.startReplicator(context, groupId, destConfigId, connectConfigId, 1000L, 2000L, fact);
        ReplicationUtils.startReceiver(groupId, connectConfigId, destConfigId, fact);
        String commandBufferId = "commandBufferId";
        Class<ServiceCommand> commandClass = ServiceCommand.class;
        ReplicationUtils.createReceiverRoute(groupId, commandBufferId, "key", "id", commandClass, fact);
        ReplicationUtils.createReplicationBuffer(groupId, commandBufferId, "key", "id", 25, commandClass, fact);
    }

    public static ManagedServiceGroup startReplicator(BundleContext context, String replicationGroupId, String destConfigId, String connectionConfigId, long initialReplicationDelay, long replicationPeriod, ManagedServiceFactory fact) {
        List<Configuration<String>> lifecycles = ReplicationUtils.getReplicatorLifecycleConfigs(context, replicationGroupId, initialReplicationDelay, replicationPeriod, destConfigId, connectionConfigId);
        Configuration groupConf = RKManagedGroupConfigUtils.buildManagedGroupConfig((String)replicationGroupId, null, lifecycles);
        ManagedServiceGroup group = RKManagedGroupConfigUtils.buildGroup((ManagedServiceFactory)fact, (Configuration)groupConf);
        group.start();
        return group;
    }

    private static List<Configuration<String>> getReplicatorLifecycleConfigs(BundleContext context, String replicationGroupId, long initialReplicationDelay, long replicationPeriod, String destConfigId, String connectionConfigId) {
        return new ListMergeAdapter().adapt(Arrays.asList(ReplicationSenderGroupLifecycleUtils.getJMSLifecycleConfigs(replicationGroupId, destConfigId, connectionConfigId), ReplicationSenderGroupLifecycleUtils.getReplicationSenderLifecycleConfigs(replicationGroupId), ReplicationSenderGroupLifecycleUtils.getCollectorLifecycleConfigs(replicationGroupId, context, null, initialReplicationDelay, replicationPeriod, null)));
    }

    public static <T> ManagedServiceGroup createReplicationBuffer(String replicationGroupId, String bufferId, String producerIdKey, String producerId, int bufferCapacity, Class<T> messageClass, ManagedServiceFactory fact) {
        ArrayList<Configuration<String>> configs = new ArrayList<Configuration<String>>(ReplicationSenderGroupLifecycleUtils.getReplicationBufferLifecycleConfigs(replicationGroupId, bufferId, messageClass.toString(), null, bufferCapacity));
        configs.add(NodeLinkLifecycleUtils.producerConsumerLinkLifecycleConfig(bufferId + "LinkId", null, producerIdKey, producerId, null, "eventBufferNode", bufferId, null));
        Configuration groupConf = RKManagedGroupConfigUtils.buildManagedGroupConfig((String)replicationGroupId, null, configs);
        ManagedServiceGroup group = RKManagedGroupConfigUtils.buildGroup((ManagedServiceFactory)fact, (Configuration)groupConf);
        group.start();
        return group;
    }

    public static <T> ManagedServiceGroup createAlternateReplicationBuffer(String replicationGroupId, String bufferRouteKey, Source<T> valueSource, Class<T> messageClass, ManagedServiceFactory fact) {
        ArrayList<Configuration<String>> configs = new ArrayList<Configuration<String>>(ReplicationSenderGroupLifecycleUtils.getAlternateReplicationBufferLifecycleConfigs(replicationGroupId, bufferRouteKey, messageClass.toString(), valueSource));
        Configuration groupConf = RKManagedGroupConfigUtils.buildManagedGroupConfig((String)replicationGroupId, null, configs);
        ManagedServiceGroup group = RKManagedGroupConfigUtils.buildGroup((ManagedServiceFactory)fact, (Configuration)groupConf);
        group.start();
        return group;
    }

    public static <T> ManagedServiceGroup createReceiverRoute(String receiverGroupId, String routingKey, String consumerIdKey, String consumerId, Class<T> messageClass, ManagedServiceFactory fact) {
        List<Configuration> configs = Arrays.asList(ReplicationReceiverGroupLifecycleUtils.getReplicationRouteLinkLifecycleConfig(receiverGroupId, routingKey + "LinkId", routingKey, consumerIdKey, consumerId), ReplicationReceiverGroupLifecycleUtils.getReplicationDecoderLinkLifecycleConfig(receiverGroupId, routingKey + DECODER_LINK_ID_SUFFIX, messageClass.toString()));
        Configuration groupConf = RKManagedGroupConfigUtils.buildManagedGroupConfig((String)receiverGroupId, null, configs);
        ManagedServiceGroup group = RKManagedGroupConfigUtils.buildGroup((ManagedServiceFactory)fact, (Configuration)groupConf);
        group.start();
        return group;
    }

    public static ManagedServiceGroup startReceiver(String receiverGroupId, String destConfigId, String connectionConfigId, ManagedServiceFactory fact) {
        List lifecycles = new ListMergeAdapter().adapt(Arrays.asList(ReplicationReceiverGroupLifecycleUtils.getJMSLifecycleConfigs(receiverGroupId, destConfigId, connectionConfigId), ReplicationReceiverGroupLifecycleUtils.getReplicationReceiverLifecycleConfigs(receiverGroupId)));
        Configuration groupConf = RKManagedGroupConfigUtils.buildManagedGroupConfig((String)receiverGroupId, null, (List)lifecycles);
        ManagedServiceGroup group = RKManagedGroupConfigUtils.buildGroup((ManagedServiceFactory)fact, (Configuration)groupConf);
        group.start();
        return group;
    }
}

